/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.clustr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrEntry;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrGroupName;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrId;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.util.NoNullElementsSet;

public class ClustrEntryImpl
implements PersistentObject,
ClustrEntry {
    private ClustrId clustrId;
    private ClustrGroupName groupName;
    private long internalID = 0L;
    private int size = 0;
    private float zLevel = 0.0f;
    private float averageZScore = 0.0f;
    private Collection<UniProtAccession> accessions = new ArrayList<UniProtAccession>();
    private int percentageLinkage = 0;
    private Set<UniParcEntry> uniParcEntries;

    @Override
    public float getAverageZScore() {
        return this.averageZScore;
    }

    @Override
    public void setAverageZScore(float averageZScore) {
        this.averageZScore = averageZScore;
    }

    @Override
    public Collection<UniProtAccession> getUniProtAccessions() {
        return this.accessions;
    }

    @Override
    public void setUniProtAccessions(Collection<UniProtAccession> accessions) {
        this.accessions = accessions;
    }

    @Override
    public int getPercentageLinkage() {
        return this.percentageLinkage;
    }

    @Override
    public void setPercentageLinkage(int percentageLinkage) {
        this.percentageLinkage = percentageLinkage;
    }

    public ClustrEntryImpl(ClustrEntry copy) {
        this.uniParcEntries = new NoNullElementsSet<UniParcEntry>(new HashSet());
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        this.setClustrId(copy.getClustrId());
        this.setInternalID(copy.getInternalID());
        this.setSize(copy.getSize());
        this.setZLevel(copy.getZLevel());
        this.setGroupName(copy.getGroupName());
        for (UniParcEntry uniparc : copy.getUniParcEntries()) {
            this.uniParcEntries.add(uniparc);
        }
        this.averageZScore = copy.getAverageZScore();
        this.percentageLinkage = copy.getPercentageLinkage();
        for (UniProtAccession accession : copy.getUniProtAccessions()) {
            this.accessions.add(accession);
        }
    }

    public ClustrEntryImpl() {
    }

    @Override
    public long getId() {
        return this.internalID;
    }

    @Override
    public void setId(long id) {
        this.internalID = id;
    }

    @Override
    public void setClustrId(ClustrId accession) {
        if (accession == null) {
            throw new IllegalArgumentException();
        }
        this.clustrId = accession;
    }

    @Override
    public ClustrId getClustrId() {
        return this.clustrId;
    }

    @Override
    public void setInternalID(int internalID) {
        this.internalID = internalID;
    }

    @Override
    public int getInternalID() {
        return new Long(this.internalID).intValue();
    }

    @Override
    public void setZLevel(float level) {
        this.zLevel = level;
    }

    @Override
    public float getZLevel() {
        return this.zLevel;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setGroupName(ClustrGroupName groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException();
        }
        this.groupName = groupName;
    }

    @Override
    public ClustrGroupName getGroupName() {
        return this.groupName;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public Set<UniParcEntry> getUniParcEntries() {
        return this.uniParcEntries;
    }

    @Override
    public void setUniParcEntries(Set<UniParcEntry> entries) {
        if (entries == null) {
            throw new IllegalArgumentException();
        }
        this.uniParcEntries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClustrEntryImpl that = (ClustrEntryImpl)o;
        if (Float.compare(that.averageZScore, this.averageZScore) != 0) {
            return false;
        }
        if (this.internalID != that.internalID) {
            return false;
        }
        if (this.percentageLinkage != that.percentageLinkage) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        if (Float.compare(that.zLevel, this.zLevel) != 0) {
            return false;
        }
        if (this.accessions != null ? !((Object)this.accessions).equals(that.accessions) : that.accessions != null) {
            return false;
        }
        if (this.clustrId != null ? !this.clustrId.equals(that.clustrId) : that.clustrId != null) {
            return false;
        }
        if (this.groupName != null ? !this.groupName.equals(that.groupName) : that.groupName != null) {
            return false;
        }
        return !(this.uniParcEntries != null ? !((Object)this.uniParcEntries).equals(that.uniParcEntries) : that.uniParcEntries != null);
    }

    public int hashCode() {
        int result = this.clustrId != null ? this.clustrId.hashCode() : 0;
        result = 31 * result + (this.groupName != null ? this.groupName.hashCode() : 0);
        result = 31 * result + this.size;
        result = (float)(31 * result) + this.zLevel != 0.0f ? Float.floatToIntBits(this.zLevel) : 0;
        result = (float)(31 * result) + this.averageZScore != 0.0f ? Float.floatToIntBits(this.averageZScore) : 0;
        result = 31 * result + (this.accessions != null ? ((Object)this.accessions).hashCode() : 0);
        result = 31 * result + this.percentageLinkage;
        result = 31 * result + (this.uniParcEntries != null ? ((Object)this.uniParcEntries).hashCode() : 0);
        return result;
    }
}

