/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.blast.parameters;

import uk.ac.ebi.kraken.interfaces.blast.SimilaritySearchOption;

public enum DatabaseOptions implements SimilaritySearchOption
{
    UNIPROT_SP("UniProt Annotated", "swissprot"),
    UNIPROT_SP_TR("UniProt All", "uniprot"),
    UNIPROTKB("UniProtKB", "uniprotkb"),
    SWISSPROT("UniProtKB Annotated", "uniprotkb_swissprot"),
    TREMBL("UniProtKB/TrEMBL", "uniprotkb_trembl"),
    UNIREF_100("UniRef 100 (100% Identity)", "uniref100"),
    UNIREF_90("UniRef 90 (90% Identity)", "uniref90"),
    UNIREF_50("UniRef 50 (50% Identity)", "uniref50"),
    UNIPROT_ARCHAEA("UniProt Archaea", "uniprotkb_archaea"),
    UNIPROT_ARTHROPODA("UniProt Viruses", "uniprotkb_arthropoda"),
    UNIPROT_BACTERIA("UniProt Bacteria", "uniprotkb_bacteria"),
    UNIPROT_COMPLETE_MICROBIAL_PROTEOMES("UniProt Complete Microbial Proteomes", "uniprotkb_complete_microbial_proteomes"),
    UNIPROT_FUNGI("UniProt Fungi", "uniprotkb_fungi"),
    UNIPROT_HUMAN("UniProt Human", "uniprotkb_human"),
    UNIPROT_MAMMALS("UniProt Mammals", "uniprotkb_mammals"),
    UNIPROT_NEMATODA("UniProt Viruses", "uniprotkb_nematoda"),
    UNIPROT_RODENTS("UniProt Rodents", "uniprotkb_rodents"),
    UNIPROT_VIRIDIPLANTAE("UniProt Viridiplantae", "uniprotkb_viridiplantae"),
    UNIPROT_VERTEBRATES("UniProt Vertebrates", "uniprotkb_vertebrates"),
    UNIPROT_VIRUSES("UniProt Viruses", "uniprotkb_viruses"),
    UNIPROT_PDB("UniProt PDB", "uniprotkb_pdb"),
    UNIPROT_EUKARYOTA("UniProt Eukaryota", "uniprotkb_eukaryota"),
    UNIMES("um", "unimes"),
    UNIPARC("UniParc", "uniparc");

    private String displayName;
    private String wsName;

    private DatabaseOptions(String displayName, String wsName) {
        this.displayName = displayName;
        this.wsName = wsName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getWebServiceName() {
        return this.wsName;
    }

    public static DatabaseOptions typeOf(String value) {
        for (DatabaseOptions db : DatabaseOptions.values()) {
            if (!db.getDisplayName().equals(value) && !db.getWebServiceName().equals(value)) continue;
            return db;
        }
        throw new IllegalArgumentException("the data source with the description " + value + " doesn't exist");
    }
}

