/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.blast;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.blast.LocalAlignment;
import uk.ac.ebi.kraken.interfaces.blast.SequenceAlignment;
import uk.ac.ebi.kraken.model.blast.SequenceAlignmentImpl;
import uk.ac.ebi.kraken.model.common.PersistentObject;

public class LocalAlignmentImpl
implements LocalAlignment,
PersistentObject,
Serializable {
    private long id;
    public static int SEQUENCE_LENGTH = 55;
    private int score;
    private Double expectation;
    private float probability;
    private float bits;
    private float identity;
    private float positives;
    private SequenceAlignment sequenceAlignment = new SequenceAlignmentImpl();
    private List<SequenceAlignment> viewAlignments;

    @Override
    public Double getExpectation() {
        return this.expectation;
    }

    @Override
    public void setExpectation(Double expectation) {
        this.expectation = expectation;
    }

    @Override
    public float getIdentity() {
        return this.identity;
    }

    @Override
    public void setIdentity(float identity) {
        this.identity = identity;
    }

    @Override
    public float getPositives() {
        return this.positives;
    }

    @Override
    public void setPositives(float positives) {
        this.positives = positives;
    }

    @Override
    public float getProbability() {
        return this.probability;
    }

    @Override
    public void setProbability(float probability) {
        this.probability = probability;
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public void setScore(int score) {
        this.score = score;
    }

    @Override
    public float getBits() {
        return this.bits;
    }

    @Override
    public void setBits(float bits) {
        this.bits = bits;
    }

    @Override
    public int getEndMatchSeq() {
        return this.sequenceAlignment.getEndMatchSeq();
    }

    @Override
    public int getEndQuerySeq() {
        return this.sequenceAlignment.getEndQuerySeq();
    }

    @Override
    public String getMatchSeq() {
        return this.sequenceAlignment.getMatchSeq();
    }

    @Override
    public String getPattern() {
        return this.sequenceAlignment.getPattern();
    }

    @Override
    public String getQuerySeq() {
        return this.sequenceAlignment.getQuerySeq();
    }

    @Override
    public int getStartMatchSeq() {
        return this.sequenceAlignment.getStartMatchSeq();
    }

    @Override
    public int getStartQuerySeq() {
        return this.sequenceAlignment.getStartQuerySeq();
    }

    @Override
    public void setEndMatchSeq(int endMatchSeq) {
        this.sequenceAlignment.setEndMatchSeq(endMatchSeq);
    }

    @Override
    public void setEndQuerySeq(int endQuerySeq) {
        this.sequenceAlignment.setEndQuerySeq(endQuerySeq);
    }

    @Override
    public void setMatchSeq(String matchSeq) {
        this.sequenceAlignment.setMatchSeq(matchSeq);
    }

    @Override
    public void setPattern(String pattern) {
        this.sequenceAlignment.setPattern(pattern);
    }

    @Override
    public void setQuerySeq(String querySeq) {
        this.sequenceAlignment.setQuerySeq(querySeq);
    }

    @Override
    public void setStartMatchSeq(int startMatchSeq) {
        this.sequenceAlignment.setStartMatchSeq(startMatchSeq);
    }

    @Override
    public void setStartQuerySeq(int startQuerySeq) {
        this.sequenceAlignment.setStartQuerySeq(startQuerySeq);
    }

    @Override
    public List<SequenceAlignment> getViewAlignments() {
        if (this.viewAlignments == null) {
            this.generateViewAlignments();
        }
        return this.viewAlignments;
    }

    private void generateViewAlignments() {
        this.viewAlignments = new ArrayList<SequenceAlignment>();
        String matchSeq = this.getMatchSeq();
        String querySeq = this.getQuerySeq();
        String pattern = this.getPattern();
        StringBuilder mBuilder = new StringBuilder();
        StringBuilder qBuilder = new StringBuilder();
        StringBuilder pBuilder = new StringBuilder();
        int mCounter = this.getStartMatchSeq();
        int qCounter = this.getStartQuerySeq();
        int mStartPos = mCounter;
        int qStartPos = qCounter;
        for (int iii = 0; iii < matchSeq.length(); ++iii) {
            char mChar = matchSeq.charAt(iii);
            char qChar = querySeq.charAt(iii);
            char pChar = iii < pattern.length() ? (char)pattern.charAt(iii) : (char)' ';
            if (mChar != '-') {
                ++mCounter;
            }
            if (qChar != '-') {
                ++qCounter;
            }
            mBuilder.append(mChar);
            qBuilder.append(qChar);
            pBuilder.append(pChar);
            if ((iii + 1) % SEQUENCE_LENGTH != 0) continue;
            SequenceAlignmentImpl seqAlignment = new SequenceAlignmentImpl();
            seqAlignment.setQuerySeq(qBuilder.toString());
            seqAlignment.setMatchSeq(mBuilder.toString());
            seqAlignment.setPattern(pBuilder.toString());
            qBuilder = new StringBuilder();
            mBuilder = new StringBuilder();
            pBuilder = new StringBuilder();
            seqAlignment.setStartMatchSeq(mStartPos);
            seqAlignment.setStartQuerySeq(qStartPos);
            seqAlignment.setEndMatchSeq(mCounter);
            seqAlignment.setEndQuerySeq(qCounter);
            mStartPos = mCounter + 1;
            mStartPos = mCounter + 1;
            qStartPos = qCounter + 1;
            this.viewAlignments.add(seqAlignment);
        }
        SequenceAlignmentImpl seqAlignment = new SequenceAlignmentImpl();
        seqAlignment.setQuerySeq(qBuilder.toString());
        seqAlignment.setMatchSeq(mBuilder.toString());
        seqAlignment.setPattern(pBuilder.toString());
        seqAlignment.setStartMatchSeq(mStartPos);
        seqAlignment.setStartQuerySeq(qStartPos);
        seqAlignment.setEndMatchSeq(mCounter);
        seqAlignment.setEndQuerySeq(qCounter);
        this.viewAlignments.add(seqAlignment);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }
}

