/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.blast;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.blast.Hit;
import uk.ac.ebi.kraken.interfaces.blast.LocalAlignment;
import uk.ac.ebi.kraken.model.common.PersistentObject;

public class HitImpl
implements PersistentObject,
Hit,
Serializable {
    private static final long serialVersionUID = 1591491748244657266L;
    private long id;
    private int index = 0;
    private boolean isoFormHit;
    private String isoFormId = "";
    private String sequence = "";
    private String database = "";
    private String hitId = "";
    private Map<String, Integer> pdb = new HashMap<String, Integer>();
    private String ac = "";
    private long length;
    private String description = "";
    private List<LocalAlignment> alignments = new ArrayList<LocalAlignment>();
    private List<String> organisms = new ArrayList<String>();
    private List<String> genes = new ArrayList<String>();
    private boolean isCurated = false;
    private boolean hasUniprotId = true;
    private String uniprotId;
    private boolean isAnnotated = false;
    private boolean isSelected = false;

    public HitImpl() {
        this.alignments = new ArrayList<LocalAlignment>();
        this.organisms = new ArrayList<String>();
        this.genes = new ArrayList<String>();
    }

    @Override
    public boolean getHasUniprotId() {
        return this.hasUniprotId;
    }

    @Override
    public void setHasUniprotId(boolean hasUniprotId) {
        this.hasUniprotId = hasUniprotId;
    }

    @Override
    public String getAc() {
        return this.ac;
    }

    @Override
    public void setAc(String ac) {
        this.ac = ac;
    }

    @Override
    public List<LocalAlignment> getAlignments() {
        return this.alignments;
    }

    @Override
    public void setAlignments(List<LocalAlignment> alignments) {
        this.alignments = alignments;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getHitId() {
        return this.hitId;
    }

    @Override
    public void setHitId(String hitId) {
        this.hitId = hitId;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public void setLength(long length) {
        this.length = length;
    }

    @Override
    public List<String> getOrganisms() {
        return this.organisms;
    }

    @Override
    public List<String> getGenes() {
        return this.genes;
    }

    @Override
    public void setOrganisms(List<String> organisms) {
        this.organisms = organisms;
    }

    @Override
    public boolean isAnnotated() {
        return this.isAnnotated;
    }

    @Override
    public void setAnnotated(boolean annotated) {
        this.isAnnotated = annotated;
    }

    @Override
    public boolean isCurated() {
        return this.isCurated;
    }

    @Override
    public void setCurated(boolean curated) {
        this.isCurated = curated;
    }

    @Override
    public boolean isSelected() {
        return this.isSelected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getUniprotId() {
        return this.uniprotId;
    }

    @Override
    public void setUniprotId(String uniprotId) {
        this.uniprotId = uniprotId;
    }

    @Override
    public boolean hasUniprotId() {
        return this.getUniprotId() != null && !this.getUniprotId().equals("");
    }

    public String toString() {
        return "Hit{ac='" + this.ac + '\'' + ", index=" + this.index + ", database='" + this.database + '\'' + ", id='" + this.id + '\'' + ", length=" + this.length + ", description='" + this.description + '\'' + ", alignments=" + this.alignments + ", organisms=" + this.organisms + ", isCurated=" + this.isCurated + ", uniprotId='" + this.uniprotId + '\'' + ", isAnnotated=" + this.isAnnotated + ", isSelected=" + this.isSelected + "}\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HitImpl hit = (HitImpl)o;
        if (this.hasUniprotId != hit.hasUniprotId) {
            return false;
        }
        if (this.id != hit.id) {
            return false;
        }
        if (this.index != hit.index) {
            return false;
        }
        if (this.isAnnotated != hit.isAnnotated) {
            return false;
        }
        if (this.isCurated != hit.isCurated) {
            return false;
        }
        if (this.isSelected != hit.isSelected) {
            return false;
        }
        if (this.isoFormHit != hit.isoFormHit) {
            return false;
        }
        if (this.length != hit.length) {
            return false;
        }
        if (this.ac != null ? !this.ac.equals(hit.ac) : hit.ac != null) {
            return false;
        }
        if (this.alignments != null ? !((Object)this.alignments).equals(hit.alignments) : hit.alignments != null) {
            return false;
        }
        if (this.database != null ? !this.database.equals(hit.database) : hit.database != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(hit.description) : hit.description != null) {
            return false;
        }
        if (this.genes != null ? !((Object)this.genes).equals(hit.genes) : hit.genes != null) {
            return false;
        }
        if (this.hitId != null ? !this.hitId.equals(hit.hitId) : hit.hitId != null) {
            return false;
        }
        if (this.isoFormId != null ? !this.isoFormId.equals(hit.isoFormId) : hit.isoFormId != null) {
            return false;
        }
        if (this.organisms != null ? !((Object)this.organisms).equals(hit.organisms) : hit.organisms != null) {
            return false;
        }
        if (this.pdb != null ? !((Object)this.pdb).equals(hit.pdb) : hit.pdb != null) {
            return false;
        }
        if (this.sequence != null ? !this.sequence.equals(hit.sequence) : hit.sequence != null) {
            return false;
        }
        return !(this.uniprotId != null ? !this.uniprotId.equals(hit.uniprotId) : hit.uniprotId != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.index;
        result = 31 * result + (this.isoFormHit ? 1 : 0);
        result = 31 * result + (this.isoFormId != null ? this.isoFormId.hashCode() : 0);
        result = 31 * result + (this.sequence != null ? this.sequence.hashCode() : 0);
        result = 31 * result + (this.database != null ? this.database.hashCode() : 0);
        result = 31 * result + (this.hitId != null ? this.hitId.hashCode() : 0);
        result = 31 * result + (this.pdb != null ? ((Object)this.pdb).hashCode() : 0);
        result = 31 * result + (this.ac != null ? this.ac.hashCode() : 0);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.alignments != null ? ((Object)this.alignments).hashCode() : 0);
        result = 31 * result + (this.organisms != null ? ((Object)this.organisms).hashCode() : 0);
        result = 31 * result + (this.genes != null ? ((Object)this.genes).hashCode() : 0);
        result = 31 * result + (this.isCurated ? 1 : 0);
        result = 31 * result + (this.hasUniprotId ? 1 : 0);
        result = 31 * result + (this.uniprotId != null ? this.uniprotId.hashCode() : 0);
        result = 31 * result + (this.isAnnotated ? 1 : 0);
        result = 31 * result + (this.isSelected ? 1 : 0);
        return result;
    }

    @Override
    public void setIsoFormHit(boolean isoFormHit) {
        this.isoFormHit = isoFormHit;
    }

    @Override
    public boolean isIsoFormHit() {
        return this.isoFormHit;
    }

    @Override
    public String getIsoFormId() {
        return this.isoFormId;
    }

    @Override
    public void setIsoFormId(String isoFormId) {
        this.isoFormId = isoFormId;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Map<String, Integer> getPdb() {
        return this.pdb;
    }

    @Override
    public void setPdb(Map<String, Integer> pdb) {
        this.pdb = pdb;
    }
}

