/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import uk.ac.ebi.kraken.annotations.Stable;
import uk.ac.ebi.kraken.interfaces.ProteinData;
import uk.ac.ebi.kraken.interfaces.clustr.ClustrId;
import uk.ac.ebi.kraken.interfaces.go.GoAnnotation;
import uk.ac.ebi.kraken.interfaces.interpro.InterProGroup;
import uk.ac.ebi.kraken.interfaces.interpro.InterProMatch;
import uk.ac.ebi.kraken.interfaces.prediction.DefaultPrediction;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcId;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.model.factories.DefaultClustrFactory;
import uk.ac.ebi.kraken.model.factories.DefaultInterProFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniParcFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.model.serialize.DefaultProteinDataImplSerializer;

public class ProteinDataImpl
implements ProteinData,
Externalizable {
    public static final int serialVersionUID = 1;
    private UniProtEntry uniProtEntry;
    private List<InterProMatch> interProMatches;
    private List<InterProGroup> interProGroups;
    private List<UniParcId> uniParcIds;
    private List<ClustrId> clusterIds;
    private List<GoAnnotation> goAnnotations;
    private Set<DefaultPrediction> predictions;
    private Set<DefaultPrediction> contradictions;
    private UniParcEntry uniParcEntry;
    private EnumMap<UniRefDatabaseType, UniRefEntry> uniRefEntries;
    private Properties proteomeProperties;

    @Stable
    public ProteinDataImpl() {
        this.uniProtEntry = DefaultUniProtFactory.getInstance().buildEntry();
        this.uniParcIds = new ArrayList<UniParcId>();
        this.interProMatches = new ArrayList<InterProMatch>();
        this.interProGroups = new ArrayList<InterProGroup>();
        this.goAnnotations = new ArrayList<GoAnnotation>();
        this.clusterIds = new ArrayList<ClustrId>();
        this.predictions = new HashSet<DefaultPrediction>();
        this.contradictions = new HashSet<DefaultPrediction>();
        this.uniParcEntry = DefaultUniParcFactory.getInstance().buildEntry();
        this.uniRefEntries = new EnumMap(UniRefDatabaseType.class);
        for (UniRefDatabaseType type : UniRefDatabaseType.values()) {
            this.uniRefEntries.put(type, DefaultUniRefFactory.getInstance().buildUniRefEntry(type));
        }
        this.proteomeProperties = new Properties();
    }

    @Stable
    public ProteinDataImpl(ProteinData copy) {
        this.uniProtEntry = DefaultUniProtFactory.getInstance().buildEntry(copy.getUniProtEntry());
        this.uniParcIds = new ArrayList<UniParcId>();
        this.interProMatches = new ArrayList<InterProMatch>();
        this.interProGroups = new ArrayList<InterProGroup>();
        this.goAnnotations = new ArrayList<GoAnnotation>();
        this.clusterIds = new ArrayList<ClustrId>();
        this.predictions = new HashSet<DefaultPrediction>();
        this.contradictions = new HashSet<DefaultPrediction>();
        this.uniParcEntry = DefaultUniParcFactory.getInstance().buildEntry(copy.getUniParcEntry());
        this.uniRefEntries = new EnumMap(UniRefDatabaseType.class);
        for (ClustrId clustrId : copy.getClustrIds()) {
            this.clusterIds.add(DefaultClustrFactory.getInstance().buildClustrId(clustrId.getValue()));
        }
        for (InterProMatch match : copy.getInterProMatches()) {
            this.interProMatches.add(DefaultInterProFactory.getInstance().buildInterProMatch(match));
        }
        for (InterProGroup group : copy.getInterProGroups()) {
            this.interProGroups.add(DefaultInterProFactory.getInstance().buildInterProGroup(group));
        }
        for (UniRefDatabaseType type : UniRefDatabaseType.values()) {
            this.setUniRefEntry(copy.getUniRefEntry(type));
        }
        this.proteomeProperties = new Properties(copy.getProteomeProperties());
    }

    @Override
    @Stable
    public UniProtEntry getUniProtEntry() {
        return this.uniProtEntry;
    }

    @Override
    @Stable
    public void setUniProtEntry(UniProtEntry uniProtEntry) {
        this.uniProtEntry = uniProtEntry;
    }

    @Override
    @Stable
    public List<InterProMatch> getInterProMatches() {
        return this.interProMatches;
    }

    @Override
    @Stable
    public void setInterProMatches(List<InterProMatch> matches) {
        this.interProMatches = matches;
    }

    @Override
    public void setClustrIds(List<ClustrId> clusterList) {
        this.clusterIds = clusterList;
    }

    @Override
    public void setGoAnnotations(List<GoAnnotation> goAnnotations) {
        this.goAnnotations = goAnnotations;
    }

    @Override
    public List<ClustrId> getClustrIds() {
        return this.clusterIds;
    }

    @Override
    public List<UniParcId> getUniParcIds() {
        return this.uniParcIds;
    }

    @Override
    public void setUniParcIds(List<UniParcId> uniparcIdList) {
        this.uniParcIds = uniparcIdList;
    }

    @Override
    public List<InterProGroup> getInterProGroups() {
        return this.interProGroups;
    }

    @Override
    public List<GoAnnotation> getGoAnnotations() {
        return this.goAnnotations;
    }

    @Override
    public Set<DefaultPrediction> getPredictions() {
        return this.predictions;
    }

    @Override
    public Set<DefaultPrediction> getContradictions() {
        return this.contradictions;
    }

    @Override
    public void setInterProGroups(List<InterProGroup> interProGroups) {
        this.interProGroups = interProGroups;
    }

    @Override
    public UniParcEntry getUniParcEntry() {
        return this.uniParcEntry;
    }

    @Override
    public void setUniParcEntry(UniParcEntry entry) {
        this.uniParcEntry = entry;
    }

    @Override
    public UniRefEntry getUniRefEntry(UniRefDatabaseType type) {
        return this.uniRefEntries.get((Object)type);
    }

    public Collection<UniRefEntry> getUniRefEntries() {
        return this.uniRefEntries.values();
    }

    @Override
    public void setUniRefEntry(UniRefEntry entry) {
        if (entry != null) {
            this.uniRefEntries.put(entry.getUniRefDatabase().getType(), entry);
        }
    }

    @Override
    public void setPredictions(Set<DefaultPrediction> predictions) {
        this.predictions = predictions;
    }

    @Override
    public void setContradictions(Set<DefaultPrediction> contradictions) {
        this.contradictions = contradictions;
    }

    @Override
    @Stable
    public void writeExternal(ObjectOutput out) throws IOException {
        new DefaultProteinDataImplSerializer().writeObject(this, out);
    }

    @Override
    public Properties getProteomeProperties() {
        return this.proteomeProperties;
    }

    @Override
    public void setProteomeProperties(Properties proteomeProperties) {
        this.proteomeProperties = proteomeProperties;
    }

    @Override
    @Stable
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new DefaultProteinDataImplSerializer().readObject(this, in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProteinDataImpl that = (ProteinDataImpl)o;
        if (this.clusterIds != null ? !((Object)this.clusterIds).equals(that.clusterIds) : that.clusterIds != null) {
            return false;
        }
        if (this.contradictions != null ? !((Object)this.contradictions).equals(that.contradictions) : that.contradictions != null) {
            return false;
        }
        if (this.goAnnotations != null ? !((Object)this.goAnnotations).equals(that.goAnnotations) : that.goAnnotations != null) {
            return false;
        }
        if (this.interProGroups != null ? !((Object)this.interProGroups).equals(that.interProGroups) : that.interProGroups != null) {
            return false;
        }
        if (this.interProMatches != null ? !((Object)this.interProMatches).equals(that.interProMatches) : that.interProMatches != null) {
            return false;
        }
        if (this.predictions != null ? !((Object)this.predictions).equals(that.predictions) : that.predictions != null) {
            return false;
        }
        if (this.uniParcEntry != null ? !this.uniParcEntry.equals(that.uniParcEntry) : that.uniParcEntry != null) {
            return false;
        }
        if (this.uniParcIds != null ? !((Object)this.uniParcIds).equals(that.uniParcIds) : that.uniParcIds != null) {
            return false;
        }
        return !(this.uniProtEntry != null ? !this.uniProtEntry.equals(that.uniProtEntry) : that.uniProtEntry != null);
    }

    public int hashCode() {
        int result = this.uniProtEntry != null ? this.uniProtEntry.hashCode() : 0;
        result = 31 * result + (this.interProMatches != null ? ((Object)this.interProMatches).hashCode() : 0);
        result = 31 * result + (this.interProGroups != null ? ((Object)this.interProGroups).hashCode() : 0);
        result = 31 * result + (this.uniParcIds != null ? ((Object)this.uniParcIds).hashCode() : 0);
        result = 31 * result + (this.clusterIds != null ? ((Object)this.clusterIds).hashCode() : 0);
        result = 31 * result + (this.goAnnotations != null ? ((Object)this.goAnnotations).hashCode() : 0);
        result = 31 * result + (this.predictions != null ? ((Object)this.predictions).hashCode() : 0);
        result = 31 * result + (this.contradictions != null ? ((Object)this.contradictions).hashCode() : 0);
        result = 31 * result + (this.uniParcEntry != null ? this.uniParcEntry.hashCode() : 0);
        return result;
    }
}

