/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.features;

public enum FeatureStatus {
    EXPERIMENTAL("Experimental"),
    POTENTIAL("Potential"),
    PROBABLE("Probable"),
    BY_SIMILARITY("By similarity"),
    OTHER("Other"),
    NONE("None"),
    DEFAULT("Default");

    private String value;

    private FeatureStatus(String status) {
        this.value = status;
    }

    public String getName() {
        return this.name();
    }

    public String getValue() {
        return this.value;
    }

    public static FeatureStatus typeOf(String value) {
        for (FeatureStatus status : FeatureStatus.values()) {
            if (!status.getValue().equalsIgnoreCase(value)) continue;
            return status;
        }
        System.err.println("value = " + value);
        throw new IllegalArgumentException();
    }

    public String shortName() {
        switch (this) {
            case EXPERIMENTAL: {
                return "EXP";
            }
            case POTENTIAL: {
                return "POT";
            }
            case PROBABLE: {
                return "PRO";
            }
            case BY_SIMILARITY: {
                return "SIM";
            }
            case OTHER: {
                return "OTH";
            }
            case NONE: {
                return "NON";
            }
            case DEFAULT: {
                return "DEF";
            }
        }
        return "";
    }
}

