/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.evidences;

public enum EvidenceCode {
    ECO_0000203("ECO:0000203", "automatic assertion"),
    ECO_0000313("ECO:0000313", "imported information used in automatic assertion"),
    ECO_0000028("ECO:0000028", "motif similarity"),
    ECO_0000006("ECO:0000006", "experimental evidence"),
    ECO_0000034("ECO:0000034", "non-traceable author statement"),
    ECO_0000044("ECO:0000044", "sequence similarity"),
    ECO_0000312("ECO:0000312", "imported information used in manual assertion"),
    ECO_0000001("ECO:0000001", "inference from background scientific knowledge"),
    NOT_SPECIFIED("NOT_SPECIFIED", "NOT_SPECIFIED");

    private String code;
    private String displayName;

    private EvidenceCode(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static EvidenceCode typeOf(String ecoCode) {
        for (EvidenceCode evidenceCode : EvidenceCode.values()) {
            if (!evidenceCode.getCodeValue().equalsIgnoreCase(ecoCode)) continue;
            return evidenceCode;
        }
        throw new IllegalArgumentException(String.format("The EvidenceCode with ECO code: %s does not exist", ecoCode));
    }
}

