/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.dbx.go;

import uk.ac.ebi.kraken.interfaces.common.Value;

public enum OntologyType implements Value
{
    C,
    F,
    P,
    UNKNOWN;


    public String getDescription() {
        switch (this) {
            case C: {
                return "Cellular component";
            }
            case F: {
                return "Molecular function";
            }
            case P: {
                return "Biological process";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "unknown";
    }

    @Override
    public String getValue() {
        switch (this) {
            case C: {
                return "C:";
            }
            case F: {
                return "F:";
            }
            case P: {
                return "P:";
            }
        }
        return "";
    }

    public static OntologyType parseOntologyType(String stringToParse) {
        for (OntologyType enumType : OntologyType.values()) {
            if (!stringToParse.startsWith(enumType.getValue())) continue;
            return enumType;
        }
        throw new IllegalArgumentException("Impossible to Parse " + stringToParse);
    }

    @Override
    public void setValue(String value) {
        throw new IllegalArgumentException();
    }
}

