/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.dbx.go;

import uk.ac.ebi.kraken.interfaces.annotations.XMLTagName;
import uk.ac.ebi.kraken.interfaces.common.Value;

@XMLTagName(tagName="evidence")
public enum GoEvidenceType implements Value
{
    IDA,
    IMP,
    IGI,
    IPI,
    IEP,
    TAS,
    NAS,
    IC,
    ISS,
    IEA,
    IGC,
    RCA,
    ND,
    NR,
    EXP,
    IBA,
    IBD,
    IKR,
    IRD,
    UNKNOWN;


    public String getDescription() {
        switch (this) {
            case IDA: {
                return "inferred from direct assay";
            }
            case IMP: {
                return "inferred from mutant phenotype";
            }
            case IGI: {
                return "inferred from genetic interaction";
            }
            case IPI: {
                return "inferred from physical interaction";
            }
            case IEP: {
                return "inferred from expression pattern";
            }
            case TAS: {
                return "traceable author statement";
            }
            case NAS: {
                return "non-traceable author statement";
            }
            case IC: {
                return "inferred by curator";
            }
            case ISS: {
                return "inferred from sequence or structural similarity";
            }
            case IEA: {
                return "inferred from electronic annotation";
            }
            case IGC: {
                return "inferred from Genomic Context";
            }
            case RCA: {
                return "inferred from reviewed computational analysis";
            }
            case ND: {
                return "no biological data available";
            }
            case NR: {
                return "not recorded";
            }
            case EXP: {
                return "inferred from experiment";
            }
            case IBA: {
                return "inferred from Biological aspect of Ancestor";
            }
            case IBD: {
                return "inferred from Biological aspect of Descendant";
            }
            case IKR: {
                return "inferred from Key Residues";
            }
            case IRD: {
                return "inferred from Rapid Divergence";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "unknown";
    }

    @Override
    public String getValue() {
        switch (this) {
            case IDA: {
                return "IDA";
            }
            case IMP: {
                return "IMP";
            }
            case IGI: {
                return "IGI";
            }
            case IPI: {
                return "IPI";
            }
            case IEP: {
                return "IEP";
            }
            case TAS: {
                return "TAS";
            }
            case NAS: {
                return "NAS";
            }
            case IC: {
                return "IC";
            }
            case ISS: {
                return "ISS";
            }
            case IEA: {
                return "IEA";
            }
            case IGC: {
                return "IGC";
            }
            case RCA: {
                return "RCA";
            }
            case ND: {
                return "ND";
            }
            case NR: {
                return "NR";
            }
            case EXP: {
                return "EXP";
            }
            case IBA: {
                return "IBA";
            }
            case IBD: {
                return "IBD";
            }
            case IKR: {
                return "IKR";
            }
            case IRD: {
                return "IRD";
            }
        }
        return "";
    }

    public static GoEvidenceType parseGoEvidenceType(String stringToParse) {
        for (GoEvidenceType enumType : GoEvidenceType.values()) {
            if (!stringToParse.startsWith(enumType.getValue())) continue;
            return enumType;
        }
        throw new IllegalArgumentException("Impossible to Parse " + stringToParse);
    }

    @Override
    public void setValue(String value) {
        throw new IllegalArgumentException();
    }
}

