/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.comments;

public enum MaximumVelocityUnit {
    MILLIMOL_PER_MINUTE_AND_MILLIGRAM("mmol/min/mg", 1),
    MILLIMOL_PER_SECOND_AND_MICROGRAM("mmol/sec/ug", 2),
    MILLIMOL_PER_HOUR_AND_MILLIGRAM("mmol/h/mg", 3),
    NANOMOL_PER_HOUR_AND_MILLIGRAM("nmol/h/mg", 4),
    NANOMOL_PER_MINUTE_AND_MILLIGRAM("nmol/min/mg", 5),
    NANOMOL_PER_MINUTE_AND_NANOGRAM("nmol/min/ng", 6),
    NANOMOL_PER_SECOND_AND_MILLIGRAM("nmol/sec/mg", 7),
    MILLIMOL_PER_SECOND_AND_MILLIGRAM("mmol/sec/mg", 42),
    NANOMOL_PER_SECOND_AND_GRAM("nmol/sec/g", 41),
    PICOMOL_PER_MINUTE_AND_MICROGRAM("pmol/min/ug", 8),
    PICOMOL_PER_SECOND_AND_MILLIGRAM("pmol/sec/mg", 9),
    PICOMOL_PER_MINUTE_AND_MILLIGRAM("pmol/min/mg", 10),
    MICROMOL_PER_HOUR_AND_MILLIGRAM("umol/h/mg", 11),
    MICROMOL_PER_MINUTE_AND_MILLIGRAM("umol/min/mg", 12),
    MICROMOL_PER_SECOND_AND_MILLIGRAM("umol/sec/mg", 13),
    MICROMOL_PER_SECOND_AND_MICROGRAM("umol/sec/ug", 42),
    MICROMOL_PER_MIN_AND_MICROGRAM("umol/min/ug", 14),
    MICROMOL_PER_HOUR_AND_GRAM("umol/h/g", 15),
    PICOMOL_PER_SECOND_AND_MICROGRAM("pmol/sec/ug", 16),
    MICROMOL_PER_MINUTE_AND_GRAM("umol/min/g", 17),
    MILLIMOLAR_PER_MINUTE_AND_MILLIGRAM("mM/min/mg", 18),
    NANOMOLAR_PER_HOUR_AND_MILLIGRAM("nM/h/mg", 19),
    NANOMOLAR_PER_MINUTE_AND_MILLIGRAM("nM/min/mg", 20),
    NANOMOLAR_PER_MINUTE_AND_NANOGRAM("nM/min/ng", 21),
    NANOMOLAR_PER_SECOND_AND_MILLIGRAM("nM/sec/mg", 22),
    PICOMOLAR_PER_HOUR_AND_MICROGRAM("pM/min/ug", 23),
    MICROMOL_PER_HOUR_AND_MICROGRAM("umol/h/ug", 24),
    PICOMOLAR_PER_MINUTE_AND_MICROGRAM("pM/min/ug", 25),
    PICOMOLAR_PER_SECOND_AND_MILLIGRAM("pM/sec/mg", 26),
    MICROMOLAR_PER_HOUR_AND_MILLIGRAM("uM/h/mg", 27),
    MICROMOLAR_PER_MINUTE_AND_MILLIGRAM("uM/min/mg", 28),
    MICROMOLAR_PER_SECOND_AND_MILLIGRAM("uM/sec/mg", 29),
    MICROMOLAR_PER_HOUR_AND_MICROGRAM("uM/h/ug", 30),
    MICROMOLAR_PER_SECOND_AND_MICROGRAM("uM/min/ug", 31),
    MICROMOLAR_PER_HOUR_AND_GRAM("uM/h/g", 32),
    PICOMOLAR_PER_SECOND_AND_MICROGRAM("pM/sec/ug", 33),
    NANOMOL_PER_SECOND_AND_MICROGRAM("nmol/min/ug", 34),
    PICOMOL_PER_HOUR_AND_MILLIGRAM("pmol/h/mg", 35),
    PICOMOL_PER_HOUR_AND_MICROGRAM("pmol/h/ug", 38),
    MICROMOLAR_PER_MINUTE_AND_GRAM("uM/min/g", 36),
    NANOMOLAR_PER_MINUTE_AND_MICROGRAM("nM/min/ug", 37),
    MICROMOLAR_PER_MINUTE_AND_MICROGRAM("nmol/min/g", 38),
    NANOMOL_PER_HOUR_AND_MICROGRAM("nmol/h/ug", 39),
    MILLIMOL_PER_MINUTE_AND_GRAM("mmol/min/g", 40),
    UNKNOWN("?", 99);

    private String displayName;
    private int storageValue;

    private MaximumVelocityUnit(String name, int storageValue) {
        this.displayName = name;
        this.storageValue = storageValue;
    }

    public static MaximumVelocityUnit convert(String unit) {
        for (MaximumVelocityUnit value : MaximumVelocityUnit.values()) {
            if (!value.displayName.equals(unit)) continue;
            return value;
        }
        throw new RuntimeException("unknown unit: " + unit);
    }

    public static MaximumVelocityUnit convert(int storageValue) {
        for (MaximumVelocityUnit value : MaximumVelocityUnit.values()) {
            if (value.storageValue != storageValue) continue;
            return value;
        }
        return UNKNOWN;
    }

    public String getDisplayNameString() {
        return this.toDisplayNameString();
    }

    public String getName() {
        return this.name();
    }

    public String toDisplayNameString() {
        return this.displayName;
    }

    public int getStorageValue() {
        return this.storageValue;
    }
}

