/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot.comments;

public enum CommentType {
    FUNCTION("FUNCTION"),
    CATALYTIC_ACTIVITY("CATALYTIC ACTIVITY"),
    COFACTOR("COFACTOR"),
    ENZYME_REGULATION("ENZYME REGULATION"),
    BIOPHYSICOCHEMICAL_PROPERTIES("BIOPHYSICOCHEMICAL PROPERTIES"),
    PATHWAY("PATHWAY"),
    SUBUNIT("SUBUNIT"),
    INTERACTION("INTERACTION"),
    SUBCELLULAR_LOCATION("SUBCELLULAR LOCATION"),
    ALTERNATIVE_PRODUCTS("ALTERNATIVE PRODUCTS"),
    TISSUE_SPECIFICITY("TISSUE SPECIFICITY"),
    DEVELOPMENTAL_STAGE("DEVELOPMENTAL STAGE"),
    INDUCTION("INDUCTION"),
    DOMAIN("DOMAIN"),
    PTM("PTM"),
    RNA_EDITING("RNA EDITING"),
    MASS_SPECTROMETRY("MASS SPECTROMETRY"),
    POLYMORPHISM("POLYMORPHISM"),
    DISEASE("DISEASE"),
    DISRUPTION_PHENOTYPE("DISRUPTION PHENOTYPE"),
    ALLERGEN("ALLERGEN"),
    TOXIC_DOSE("TOXIC DOSE"),
    BIOTECHNOLOGY("BIOTECHNOLOGY"),
    PHARMACEUTICAL("PHARMACEUTICAL"),
    MISCELLANEOUS("MISCELLANEOUS"),
    SIMILARITY("SIMILARITY"),
    CAUTION("CAUTION"),
    SEQUENCE_CAUTION("SEQUENCE CAUTION"),
    WEBRESOURCE("WEB RESOURCE"),
    PAGE("PAGE"),
    UNKNOWN("UNKOWN");

    private String value;

    private CommentType(String value) {
        this.value = value;
    }

    public String toDisplayName() {
        return this.value;
    }

    public static CommentType dbTypeOf(String value) {
        for (CommentType commentType : CommentType.values()) {
            if (!commentType.toString().equalsIgnoreCase(value)) continue;
            return commentType;
        }
        throw new IllegalArgumentException("The comment type: " + value + " doesn't exist");
    }

    public static CommentType typeOf(String value) {
        for (CommentType commentType : CommentType.values()) {
            if (!commentType.toDisplayName().trim().equalsIgnoreCase(value.trim())) continue;
            return commentType;
        }
        throw new IllegalArgumentException("The comment type: " + value + " doesn't exist");
    }
}

