/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.uniprot;

public enum DatabaseType {
    EMBL,
    IPI,
    PIR,
    REFSEQ,
    UNIGENE,
    PDB,
    PDBSUM,
    HSSP,
    PROTEINMODELPORTAL,
    SMR,
    DISPROT,
    DIP,
    INTACT,
    MINT,
    STRINGXREF,
    ALLERGOME,
    CAZY,
    MEROPS,
    PEROXIBASE,
    PPTASEDB,
    REBASE,
    TCDB,
    GLYCOSUITEDB,
    PHOSPHOSITE,
    PHOSSITE,
    DMDM,
    SWISS2DPAGE,
    TWODBASEECOLI,
    AARHUSGHENT,
    ANU2DPAGE,
    COMPLUYEAST2DPAGE,
    CORNEA2DPAGE,
    DOSACCOBS2DPAGE,
    ECO2DBASE,
    OGP,
    PHCI2DPAGE,
    PMMA2DPAGE,
    RATHEART2DPAGE,
    REPRODUCTION2DPAGE,
    SIENA2DPAGE,
    UCD2DPAGE,
    WORLD2DPAGE,
    PEPTIDEATLAS,
    PRIDE,
    PROMEX,
    ENSEMBL,
    ENSEMBLBACTERIA,
    ENSEMBLFUNGI,
    ENSEMBLMETAZOA,
    ENSEMBLPLANTS,
    ENSEMBLPROTISTS,
    GENEID,
    GENOMEREVIEWS,
    KEGG,
    NMPDR,
    PATRIC,
    TIGR,
    UCSC,
    VECTORBASE,
    AGD,
    ARACHNOSERVER,
    CGD,
    CONOSERVER,
    CTD,
    CYGD,
    DICTYBASE,
    ECHOBASE,
    ECOGENE,
    EUHCVDB,
    EUPATHDB,
    FLYBASE,
    GENECARDS,
    GENEDBSPOMBE,
    GENEFARM,
    GENOLIST,
    GRAMENE,
    HINVDB,
    HGNC,
    HPA,
    LEGIOLIST,
    LEPROMA,
    MAIZEGDB,
    MIM,
    MGI,
    NEXTPROT,
    ORPHANET,
    PHARMGKB,
    PSEUDOCAP,
    RGD,
    SGD,
    TAIR,
    TUBERCULIST,
    WORMBASE,
    XENBASE,
    ZFIN,
    EGGNOG,
    GENETREE,
    HOGENOM,
    HOVERGEN,
    INPARANOID,
    OMA,
    ORTHODB,
    PHYLOMEDB,
    PROTCLUSTDB,
    BIOCYC,
    BRENDA,
    PATHWAYINTERACTIONDB,
    REACTOME,
    BINDINGDB,
    DRUGBANK,
    NEXTBIO,
    PMAPCUTDB,
    ARRAYEXPRESS,
    BGEE,
    CLEANEX,
    GENEVESTIGATOR,
    GERMONLINE,
    GO,
    HAMAP,
    INTERPRO,
    GENE3D,
    KO,
    PANTHER,
    PFAM,
    PIRSF,
    PRINTS,
    PRODOM,
    SMART,
    SUPFAM,
    TIGRFAMS,
    PROSITE,
    TRANSFAC,
    HSC2DPAGE,
    BURULIST,
    HIV,
    LISTILIST,
    MYPULIST,
    PHOTOLIST,
    SAGALIST,
    STYGENE,
    SUBTILIST,
    WORMPEP,
    LINKHUB,
    MAIZE2DPAGE,
    RZPDPROTEXP,
    UNIPEP,
    GCRDB,
    CARBBANK,
    GENEW,
    GK,
    MAIZEDB,
    MENDEL,
    MGD,
    YEPD,
    UNKNOWN;


    public String toDisplayName() {
        switch (this) {
            case EMBL: {
                return "EMBL; ";
            }
            case IPI: {
                return "IPI; ";
            }
            case PIR: {
                return "PIR; ";
            }
            case REFSEQ: {
                return "RefSeq; ";
            }
            case UNIGENE: {
                return "UniGene; ";
            }
            case PDB: {
                return "PDB; ";
            }
            case PDBSUM: {
                return "PDBsum; ";
            }
            case HSSP: {
                return "HSSP; ";
            }
            case PROTEINMODELPORTAL: {
                return "ProteinModelPortal; ";
            }
            case SMR: {
                return "SMR; ";
            }
            case DISPROT: {
                return "DisProt; ";
            }
            case DIP: {
                return "DIP; ";
            }
            case INTACT: {
                return "IntAct; ";
            }
            case MINT: {
                return "MINT; ";
            }
            case STRINGXREF: {
                return "STRING; ";
            }
            case ALLERGOME: {
                return "Allergome; ";
            }
            case CAZY: {
                return "CAZy; ";
            }
            case MEROPS: {
                return "MEROPS; ";
            }
            case PEROXIBASE: {
                return "PeroxiBase; ";
            }
            case PPTASEDB: {
                return "PptaseDB; ";
            }
            case REBASE: {
                return "REBASE; ";
            }
            case TCDB: {
                return "TCDB; ";
            }
            case GLYCOSUITEDB: {
                return "GlycoSuiteDB; ";
            }
            case PHOSPHOSITE: {
                return "PhosphoSite; ";
            }
            case PHOSSITE: {
                return "PhosSite; ";
            }
            case DMDM: {
                return "DMDM; ";
            }
            case SWISS2DPAGE: {
                return "SWISS-2DPAGE; ";
            }
            case TWODBASEECOLI: {
                return "2DBase-Ecoli; ";
            }
            case AARHUSGHENT: {
                return "Aarhus/Ghent-2DPAGE; ";
            }
            case ANU2DPAGE: {
                return "ANU-2DPAGE; ";
            }
            case COMPLUYEAST2DPAGE: {
                return "COMPLUYEAST-2DPAGE; ";
            }
            case CORNEA2DPAGE: {
                return "Cornea-2DPAGE; ";
            }
            case DOSACCOBS2DPAGE: {
                return "DOSAC-COBS-2DPAGE; ";
            }
            case ECO2DBASE: {
                return "ECO2DBASE; ";
            }
            case OGP: {
                return "OGP; ";
            }
            case PHCI2DPAGE: {
                return "PHCI-2DPAGE; ";
            }
            case PMMA2DPAGE: {
                return "PMMA-2DPAGE; ";
            }
            case RATHEART2DPAGE: {
                return "Rat-heart-2DPAGE; ";
            }
            case REPRODUCTION2DPAGE: {
                return "REPRODUCTION-2DPAGE; ";
            }
            case SIENA2DPAGE: {
                return "Siena-2DPAGE; ";
            }
            case UCD2DPAGE: {
                return "UCD-2DPAGE; ";
            }
            case WORLD2DPAGE: {
                return "World-2DPAGE; ";
            }
            case PEPTIDEATLAS: {
                return "PeptideAtlas; ";
            }
            case PRIDE: {
                return "PRIDE; ";
            }
            case PROMEX: {
                return "ProMEX; ";
            }
            case ENSEMBL: {
                return "Ensembl; ";
            }
            case ENSEMBLBACTERIA: {
                return "EnsemblBacteria; ";
            }
            case ENSEMBLFUNGI: {
                return "EnsemblFungi; ";
            }
            case ENSEMBLMETAZOA: {
                return "EnsemblMetazoa; ";
            }
            case ENSEMBLPLANTS: {
                return "EnsemblPlants; ";
            }
            case ENSEMBLPROTISTS: {
                return "EnsemblProtists; ";
            }
            case GENEID: {
                return "GeneID; ";
            }
            case GENOMEREVIEWS: {
                return "GenomeReviews; ";
            }
            case KEGG: {
                return "KEGG; ";
            }
            case NMPDR: {
                return "NMPDR; ";
            }
            case PATRIC: {
                return "PATRIC; ";
            }
            case TIGR: {
                return "TIGR; ";
            }
            case UCSC: {
                return "UCSC; ";
            }
            case VECTORBASE: {
                return "VectorBase; ";
            }
            case AGD: {
                return "AGD; ";
            }
            case ARACHNOSERVER: {
                return "ArachnoServer; ";
            }
            case CGD: {
                return "CGD; ";
            }
            case CONOSERVER: {
                return "ConoServer; ";
            }
            case CTD: {
                return "CTD; ";
            }
            case CYGD: {
                return "CYGD; ";
            }
            case DICTYBASE: {
                return "dictyBase; ";
            }
            case ECHOBASE: {
                return "EchoBASE; ";
            }
            case ECOGENE: {
                return "EcoGene; ";
            }
            case EUHCVDB: {
                return "euHCVdb; ";
            }
            case EUPATHDB: {
                return "EuPathDB; ";
            }
            case FLYBASE: {
                return "FlyBase; ";
            }
            case GENECARDS: {
                return "GeneCards; ";
            }
            case GENEDBSPOMBE: {
                return "GeneDB_Spombe; ";
            }
            case GENEFARM: {
                return "GeneFarm; ";
            }
            case GENOLIST: {
                return "GenoList; ";
            }
            case GRAMENE: {
                return "Gramene; ";
            }
            case HINVDB: {
                return "H-InvDB; ";
            }
            case HGNC: {
                return "HGNC; ";
            }
            case HPA: {
                return "HPA; ";
            }
            case LEGIOLIST: {
                return "LegioList; ";
            }
            case LEPROMA: {
                return "Leproma; ";
            }
            case MAIZEGDB: {
                return "MaizeGDB; ";
            }
            case MIM: {
                return "MIM; ";
            }
            case MGI: {
                return "MGI; ";
            }
            case NEXTPROT: {
                return "neXtProt; ";
            }
            case ORPHANET: {
                return "Orphanet; ";
            }
            case PHARMGKB: {
                return "PharmGKB; ";
            }
            case PSEUDOCAP: {
                return "PseudoCAP; ";
            }
            case RGD: {
                return "RGD; ";
            }
            case SGD: {
                return "SGD; ";
            }
            case TAIR: {
                return "TAIR; ";
            }
            case TUBERCULIST: {
                return "TubercuList; ";
            }
            case WORMBASE: {
                return "WormBase; ";
            }
            case XENBASE: {
                return "Xenbase; ";
            }
            case ZFIN: {
                return "ZFIN; ";
            }
            case EGGNOG: {
                return "eggNOG; ";
            }
            case GENETREE: {
                return "GeneTree; ";
            }
            case HOGENOM: {
                return "HOGENOM; ";
            }
            case HOVERGEN: {
                return "HOVERGEN; ";
            }
            case INPARANOID: {
                return "InParanoid; ";
            }
            case OMA: {
                return "OMA; ";
            }
            case ORTHODB: {
                return "OrthoDB; ";
            }
            case PHYLOMEDB: {
                return "PhylomeDB; ";
            }
            case PROTCLUSTDB: {
                return "ProtClustDB; ";
            }
            case BIOCYC: {
                return "BioCyc; ";
            }
            case BRENDA: {
                return "BRENDA; ";
            }
            case PATHWAYINTERACTIONDB: {
                return "Pathway_Interaction_DB; ";
            }
            case REACTOME: {
                return "Reactome; ";
            }
            case BINDINGDB: {
                return "BindingDB; ";
            }
            case DRUGBANK: {
                return "DrugBank; ";
            }
            case NEXTBIO: {
                return "NextBio; ";
            }
            case PMAPCUTDB: {
                return "PMAP-CutDB; ";
            }
            case ARRAYEXPRESS: {
                return "ArrayExpress; ";
            }
            case BGEE: {
                return "Bgee; ";
            }
            case CLEANEX: {
                return "CleanEx; ";
            }
            case GENEVESTIGATOR: {
                return "Genevestigator; ";
            }
            case GERMONLINE: {
                return "GermOnline; ";
            }
            case GO: {
                return "GO; ";
            }
            case HAMAP: {
                return "HAMAP; ";
            }
            case INTERPRO: {
                return "InterPro; ";
            }
            case GENE3D: {
                return "Gene3D; ";
            }
            case KO: {
                return "KO; ";
            }
            case PANTHER: {
                return "PANTHER; ";
            }
            case PFAM: {
                return "Pfam; ";
            }
            case PIRSF: {
                return "PIRSF; ";
            }
            case PRINTS: {
                return "PRINTS; ";
            }
            case PRODOM: {
                return "ProDom; ";
            }
            case SMART: {
                return "SMART; ";
            }
            case SUPFAM: {
                return "SUPFAM; ";
            }
            case TIGRFAMS: {
                return "TIGRFAMs; ";
            }
            case PROSITE: {
                return "PROSITE; ";
            }
            case TRANSFAC: {
                return "TRANSFAC; ";
            }
            case HSC2DPAGE: {
                return "HSC-2DPAGE; ";
            }
            case BURULIST: {
                return "BuruList; ";
            }
            case HIV: {
                return "HIV; ";
            }
            case LISTILIST: {
                return "ListiList; ";
            }
            case MYPULIST: {
                return "MypuList; ";
            }
            case PHOTOLIST: {
                return "PhotoList; ";
            }
            case SAGALIST: {
                return "SagaList; ";
            }
            case STYGENE: {
                return "StyGene; ";
            }
            case SUBTILIST: {
                return "SubtiList; ";
            }
            case WORMPEP: {
                return "WormPep; ";
            }
            case LINKHUB: {
                return "LinkHub; ";
            }
            case MAIZE2DPAGE: {
                return "Maize-2DPAGE; ";
            }
            case RZPDPROTEXP: {
                return "RZPD-ProtExp; ";
            }
            case UNIPEP: {
                return "UniPep; ";
            }
            case GCRDB: {
                return "GCRDb; ";
            }
            case CARBBANK: {
                return "CarbBank; ";
            }
            case GENEW: {
                return "Genew; ";
            }
            case GK: {
                return "GK; ";
            }
            case MAIZEDB: {
                return "MaizeDB; ";
            }
            case MENDEL: {
                return "Mendel; ";
            }
            case MGD: {
                return "MGD; ";
            }
            case YEPD: {
                return "YEPD; ";
            }
        }
        return "UNKNWON";
    }

    public String toName() {
        switch (this) {
            case EMBL: {
                return "EMBL";
            }
            case IPI: {
                return "IPI";
            }
            case PIR: {
                return "PIR";
            }
            case REFSEQ: {
                return "RefSeq";
            }
            case UNIGENE: {
                return "UniGene";
            }
            case PDB: {
                return "PDB";
            }
            case PDBSUM: {
                return "PDBsum";
            }
            case HSSP: {
                return "HSSP";
            }
            case PROTEINMODELPORTAL: {
                return "ProteinModelPortal";
            }
            case SMR: {
                return "SMR";
            }
            case DISPROT: {
                return "DisProt";
            }
            case DIP: {
                return "DIP";
            }
            case INTACT: {
                return "IntAct";
            }
            case MINT: {
                return "MINT";
            }
            case STRINGXREF: {
                return "String";
            }
            case ALLERGOME: {
                return "Allergome";
            }
            case CAZY: {
                return "CAZy";
            }
            case MEROPS: {
                return "MEROPS";
            }
            case PEROXIBASE: {
                return "PeroxiBase";
            }
            case PPTASEDB: {
                return "PptaseDB";
            }
            case REBASE: {
                return "REBASE";
            }
            case TCDB: {
                return "Tcdb";
            }
            case GLYCOSUITEDB: {
                return "GlycoSuiteDB";
            }
            case PHOSPHOSITE: {
                return "PhosphoSite";
            }
            case PHOSSITE: {
                return "PhosSite";
            }
            case DMDM: {
                return "DMDM";
            }
            case SWISS2DPAGE: {
                return "SWISS-2DPAGE";
            }
            case TWODBASEECOLI: {
                return "2DBase-Ecoli";
            }
            case AARHUSGHENT: {
                return "Aarhus/Ghent-2DPAGE";
            }
            case ANU2DPAGE: {
                return "ANU-2DPAGE";
            }
            case COMPLUYEAST2DPAGE: {
                return "COMPLUYEAST-2DPAGE";
            }
            case CORNEA2DPAGE: {
                return "Cornea-2DPAGE";
            }
            case DOSACCOBS2DPAGE: {
                return "DOSAC-COBS-2DPAGE";
            }
            case ECO2DBASE: {
                return "ECO2DBASE";
            }
            case OGP: {
                return "OGP";
            }
            case PHCI2DPAGE: {
                return "PHCI-2DPAGE";
            }
            case PMMA2DPAGE: {
                return "PMMA-2DPAGE";
            }
            case RATHEART2DPAGE: {
                return "Rat-heart-2DPAGE";
            }
            case REPRODUCTION2DPAGE: {
                return "REPRODUCTION-2DPAGE";
            }
            case SIENA2DPAGE: {
                return "Siena-2DPAGE";
            }
            case UCD2DPAGE: {
                return "UCD-2DPAGE";
            }
            case WORLD2DPAGE: {
                return "World-2DPAGE";
            }
            case PEPTIDEATLAS: {
                return "PeptideAtlas";
            }
            case PRIDE: {
                return "PRIDE";
            }
            case PROMEX: {
                return "ProMEX";
            }
            case ENSEMBL: {
                return "Ensembl";
            }
            case ENSEMBLBACTERIA: {
                return "EnsemblBacteria";
            }
            case ENSEMBLFUNGI: {
                return "EnsemblFungi";
            }
            case ENSEMBLMETAZOA: {
                return "EnsemblMetazoa";
            }
            case ENSEMBLPLANTS: {
                return "EnsemblPlants";
            }
            case ENSEMBLPROTISTS: {
                return "EnsemblProtists";
            }
            case GENEID: {
                return "GeneId";
            }
            case GENOMEREVIEWS: {
                return "GenomeReviews";
            }
            case KEGG: {
                return "KEGG";
            }
            case NMPDR: {
                return "NMPDR";
            }
            case PATRIC: {
                return "PATRIC";
            }
            case TIGR: {
                return "TIGR";
            }
            case UCSC: {
                return "Ucsc";
            }
            case VECTORBASE: {
                return "VectorBase";
            }
            case AGD: {
                return "AGD";
            }
            case ARACHNOSERVER: {
                return "ArachnoServer";
            }
            case CGD: {
                return "CGD";
            }
            case CONOSERVER: {
                return "ConoServer";
            }
            case CTD: {
                return "Ctd";
            }
            case CYGD: {
                return "CYGD";
            }
            case DICTYBASE: {
                return "dictyBase";
            }
            case ECHOBASE: {
                return "EchoBASE";
            }
            case ECOGENE: {
                return "EcoGene";
            }
            case EUHCVDB: {
                return "euHCVdb";
            }
            case EUPATHDB: {
                return "EuPathDB";
            }
            case FLYBASE: {
                return "FlyBase";
            }
            case GENECARDS: {
                return "GeneCards";
            }
            case GENEDBSPOMBE: {
                return "GeneDB_Spombe";
            }
            case GENEFARM: {
                return "GeneFarm";
            }
            case GENOLIST: {
                return "GenoList";
            }
            case GRAMENE: {
                return "Gramene";
            }
            case HINVDB: {
                return "H-InvDB";
            }
            case HGNC: {
                return "HGNC";
            }
            case HPA: {
                return "HPA";
            }
            case LEGIOLIST: {
                return "LegioList";
            }
            case LEPROMA: {
                return "Leproma";
            }
            case MAIZEGDB: {
                return "MaizeGDB";
            }
            case MIM: {
                return "MIM";
            }
            case MGI: {
                return "MGI";
            }
            case NEXTPROT: {
                return "neXtProt";
            }
            case ORPHANET: {
                return "Orphanet";
            }
            case PHARMGKB: {
                return "PharmGKB";
            }
            case PSEUDOCAP: {
                return "PseudoCAP";
            }
            case RGD: {
                return "RGD";
            }
            case SGD: {
                return "SGD";
            }
            case TAIR: {
                return "TAIR";
            }
            case TUBERCULIST: {
                return "TubercuList";
            }
            case WORMBASE: {
                return "WormBase";
            }
            case XENBASE: {
                return "Xenbase";
            }
            case ZFIN: {
                return "ZFIN";
            }
            case EGGNOG: {
                return "eggNOG";
            }
            case GENETREE: {
                return "GeneTree";
            }
            case HOGENOM: {
                return "HOGENOM";
            }
            case HOVERGEN: {
                return "HOVERGEN";
            }
            case INPARANOID: {
                return "InParanoid";
            }
            case OMA: {
                return "OMA";
            }
            case ORTHODB: {
                return "OrthoDB";
            }
            case PHYLOMEDB: {
                return "PhylomeDB";
            }
            case PROTCLUSTDB: {
                return "ProtClustDB";
            }
            case BIOCYC: {
                return "BioCyc";
            }
            case BRENDA: {
                return "BRENDA";
            }
            case PATHWAYINTERACTIONDB: {
                return "Pathway_Interaction_DB";
            }
            case REACTOME: {
                return "Reactome";
            }
            case BINDINGDB: {
                return "BindingDB";
            }
            case DRUGBANK: {
                return "DrugBank";
            }
            case NEXTBIO: {
                return "NextBio";
            }
            case PMAPCUTDB: {
                return "PMAP-CutDB";
            }
            case ARRAYEXPRESS: {
                return "ArrayExpress";
            }
            case BGEE: {
                return "Bgee";
            }
            case CLEANEX: {
                return "CleanEx";
            }
            case GENEVESTIGATOR: {
                return "Genevestigator";
            }
            case GERMONLINE: {
                return "GermOnline";
            }
            case GO: {
                return "Go";
            }
            case HAMAP: {
                return "HAMAP";
            }
            case INTERPRO: {
                return "InterPro";
            }
            case GENE3D: {
                return "Gene3D";
            }
            case KO: {
                return "KO";
            }
            case PANTHER: {
                return "PANTHER";
            }
            case PFAM: {
                return "Pfam";
            }
            case PIRSF: {
                return "PIRSF";
            }
            case PRINTS: {
                return "PRINTS";
            }
            case PRODOM: {
                return "ProDom";
            }
            case SMART: {
                return "SMART";
            }
            case SUPFAM: {
                return "SUPFAM";
            }
            case TIGRFAMS: {
                return "TIGRFAMs";
            }
            case PROSITE: {
                return "PROSITE";
            }
            case TRANSFAC: {
                return "TRANSFAC";
            }
            case HSC2DPAGE: {
                return "HSC-2DPAGE";
            }
            case BURULIST: {
                return "BuruList";
            }
            case HIV: {
                return "HIV";
            }
            case LISTILIST: {
                return "ListiList";
            }
            case MYPULIST: {
                return "MypuList";
            }
            case PHOTOLIST: {
                return "PhotoList";
            }
            case SAGALIST: {
                return "SagaList";
            }
            case STYGENE: {
                return "StyGene";
            }
            case SUBTILIST: {
                return "SubtiList";
            }
            case WORMPEP: {
                return "WormPep";
            }
            case LINKHUB: {
                return "LinkHub";
            }
            case MAIZE2DPAGE: {
                return "Maize-2DPAGE";
            }
            case RZPDPROTEXP: {
                return "RZPD-ProtExp";
            }
            case UNIPEP: {
                return "UniPep";
            }
            case GCRDB: {
                return "Gcrdb";
            }
            case CARBBANK: {
                return "CarbBank";
            }
            case GENEW: {
                return "Genew";
            }
            case GK: {
                return "GK";
            }
            case MAIZEDB: {
                return "MaizeDB";
            }
            case MENDEL: {
                return "Mendel";
            }
            case MGD: {
                return "MGD";
            }
            case YEPD: {
                return "YEPD";
            }
        }
        return "UNKNOWN";
    }

    public static DatabaseType getDatabaseType(String databaseName) {
        if ("EMBL".equalsIgnoreCase(databaseName)) {
            return EMBL;
        }
        if ("IPI".equalsIgnoreCase(databaseName)) {
            return IPI;
        }
        if ("PIR".equalsIgnoreCase(databaseName)) {
            return PIR;
        }
        if ("RefSeq".equalsIgnoreCase(databaseName)) {
            return REFSEQ;
        }
        if ("UniGene".equalsIgnoreCase(databaseName)) {
            return UNIGENE;
        }
        if ("PDB".equalsIgnoreCase(databaseName)) {
            return PDB;
        }
        if ("PDBsum".equalsIgnoreCase(databaseName)) {
            return PDBSUM;
        }
        if ("HSSP".equalsIgnoreCase(databaseName)) {
            return HSSP;
        }
        if ("ProteinModelPortal".equalsIgnoreCase(databaseName)) {
            return PROTEINMODELPORTAL;
        }
        if ("SMR".equalsIgnoreCase(databaseName)) {
            return SMR;
        }
        if ("DisProt".equalsIgnoreCase(databaseName)) {
            return DISPROT;
        }
        if ("DIP".equalsIgnoreCase(databaseName)) {
            return DIP;
        }
        if ("IntAct".equalsIgnoreCase(databaseName)) {
            return INTACT;
        }
        if ("MINT".equalsIgnoreCase(databaseName)) {
            return MINT;
        }
        if ("String".equalsIgnoreCase(databaseName)) {
            return STRINGXREF;
        }
        if ("Allergome".equalsIgnoreCase(databaseName)) {
            return ALLERGOME;
        }
        if ("CAZy".equalsIgnoreCase(databaseName)) {
            return CAZY;
        }
        if ("MEROPS".equalsIgnoreCase(databaseName)) {
            return MEROPS;
        }
        if ("PeroxiBase".equalsIgnoreCase(databaseName)) {
            return PEROXIBASE;
        }
        if ("PptaseDB".equalsIgnoreCase(databaseName)) {
            return PPTASEDB;
        }
        if ("REBASE".equalsIgnoreCase(databaseName)) {
            return REBASE;
        }
        if ("Tcdb".equalsIgnoreCase(databaseName)) {
            return TCDB;
        }
        if ("GlycoSuiteDB".equalsIgnoreCase(databaseName)) {
            return GLYCOSUITEDB;
        }
        if ("PhosphoSite".equalsIgnoreCase(databaseName)) {
            return PHOSPHOSITE;
        }
        if ("PhosSite".equalsIgnoreCase(databaseName)) {
            return PHOSSITE;
        }
        if ("DMDM".equalsIgnoreCase(databaseName)) {
            return DMDM;
        }
        if ("SWISS-2DPAGE".equalsIgnoreCase(databaseName)) {
            return SWISS2DPAGE;
        }
        if ("2DBase-Ecoli".equalsIgnoreCase(databaseName)) {
            return TWODBASEECOLI;
        }
        if ("Aarhus/Ghent-2DPAGE".equalsIgnoreCase(databaseName)) {
            return AARHUSGHENT;
        }
        if ("ANU-2DPAGE".equalsIgnoreCase(databaseName)) {
            return ANU2DPAGE;
        }
        if ("COMPLUYEAST-2DPAGE".equalsIgnoreCase(databaseName)) {
            return COMPLUYEAST2DPAGE;
        }
        if ("Cornea-2DPAGE".equalsIgnoreCase(databaseName)) {
            return CORNEA2DPAGE;
        }
        if ("DOSAC-COBS-2DPAGE".equalsIgnoreCase(databaseName)) {
            return DOSACCOBS2DPAGE;
        }
        if ("ECO2DBASE".equalsIgnoreCase(databaseName)) {
            return ECO2DBASE;
        }
        if ("OGP".equalsIgnoreCase(databaseName)) {
            return OGP;
        }
        if ("PHCI-2DPAGE".equalsIgnoreCase(databaseName)) {
            return PHCI2DPAGE;
        }
        if ("PMMA-2DPAGE".equalsIgnoreCase(databaseName)) {
            return PMMA2DPAGE;
        }
        if ("Rat-heart-2DPAGE".equalsIgnoreCase(databaseName)) {
            return RATHEART2DPAGE;
        }
        if ("REPRODUCTION-2DPAGE".equalsIgnoreCase(databaseName)) {
            return REPRODUCTION2DPAGE;
        }
        if ("Siena-2DPAGE".equalsIgnoreCase(databaseName)) {
            return SIENA2DPAGE;
        }
        if ("UCD-2DPAGE".equalsIgnoreCase(databaseName)) {
            return UCD2DPAGE;
        }
        if ("World-2DPAGE".equalsIgnoreCase(databaseName)) {
            return WORLD2DPAGE;
        }
        if ("PeptideAtlas".equalsIgnoreCase(databaseName)) {
            return PEPTIDEATLAS;
        }
        if ("PRIDE".equalsIgnoreCase(databaseName)) {
            return PRIDE;
        }
        if ("ProMEX".equalsIgnoreCase(databaseName)) {
            return PROMEX;
        }
        if ("Ensembl".equalsIgnoreCase(databaseName)) {
            return ENSEMBL;
        }
        if ("EnsemblBacteria".equalsIgnoreCase(databaseName)) {
            return ENSEMBLBACTERIA;
        }
        if ("EnsemblFungi".equalsIgnoreCase(databaseName)) {
            return ENSEMBLFUNGI;
        }
        if ("EnsemblMetazoa".equalsIgnoreCase(databaseName)) {
            return ENSEMBLMETAZOA;
        }
        if ("EnsemblPlants".equalsIgnoreCase(databaseName)) {
            return ENSEMBLPLANTS;
        }
        if ("EnsemblProtists".equalsIgnoreCase(databaseName)) {
            return ENSEMBLPROTISTS;
        }
        if ("GeneId".equalsIgnoreCase(databaseName)) {
            return GENEID;
        }
        if ("GenomeReviews".equalsIgnoreCase(databaseName)) {
            return GENOMEREVIEWS;
        }
        if ("KEGG".equalsIgnoreCase(databaseName)) {
            return KEGG;
        }
        if ("NMPDR".equalsIgnoreCase(databaseName)) {
            return NMPDR;
        }
        if ("PATRIC".equalsIgnoreCase(databaseName)) {
            return PATRIC;
        }
        if ("TIGR".equalsIgnoreCase(databaseName)) {
            return TIGR;
        }
        if ("Ucsc".equalsIgnoreCase(databaseName)) {
            return UCSC;
        }
        if ("VectorBase".equalsIgnoreCase(databaseName)) {
            return VECTORBASE;
        }
        if ("AGD".equalsIgnoreCase(databaseName)) {
            return AGD;
        }
        if ("ArachnoServer".equalsIgnoreCase(databaseName)) {
            return ARACHNOSERVER;
        }
        if ("CGD".equalsIgnoreCase(databaseName)) {
            return CGD;
        }
        if ("ConoServer".equalsIgnoreCase(databaseName)) {
            return CONOSERVER;
        }
        if ("Ctd".equalsIgnoreCase(databaseName)) {
            return CTD;
        }
        if ("CYGD".equalsIgnoreCase(databaseName)) {
            return CYGD;
        }
        if ("dictyBase".equalsIgnoreCase(databaseName)) {
            return DICTYBASE;
        }
        if ("EchoBASE".equalsIgnoreCase(databaseName)) {
            return ECHOBASE;
        }
        if ("EcoGene".equalsIgnoreCase(databaseName)) {
            return ECOGENE;
        }
        if ("euHCVdb".equalsIgnoreCase(databaseName)) {
            return EUHCVDB;
        }
        if ("EuPathDB".equalsIgnoreCase(databaseName)) {
            return EUPATHDB;
        }
        if ("FlyBase".equalsIgnoreCase(databaseName)) {
            return FLYBASE;
        }
        if ("GeneCards".equalsIgnoreCase(databaseName)) {
            return GENECARDS;
        }
        if ("GeneDB_Spombe".equalsIgnoreCase(databaseName)) {
            return GENEDBSPOMBE;
        }
        if ("GeneFarm".equalsIgnoreCase(databaseName)) {
            return GENEFARM;
        }
        if ("GenoList".equalsIgnoreCase(databaseName)) {
            return GENOLIST;
        }
        if ("Gramene".equalsIgnoreCase(databaseName)) {
            return GRAMENE;
        }
        if ("H-InvDB".equalsIgnoreCase(databaseName)) {
            return HINVDB;
        }
        if ("HGNC".equalsIgnoreCase(databaseName)) {
            return HGNC;
        }
        if ("HPA".equalsIgnoreCase(databaseName)) {
            return HPA;
        }
        if ("LegioList".equalsIgnoreCase(databaseName)) {
            return LEGIOLIST;
        }
        if ("Leproma".equalsIgnoreCase(databaseName)) {
            return LEPROMA;
        }
        if ("MaizeGDB".equalsIgnoreCase(databaseName)) {
            return MAIZEGDB;
        }
        if ("MIM".equalsIgnoreCase(databaseName)) {
            return MIM;
        }
        if ("MGI".equalsIgnoreCase(databaseName)) {
            return MGI;
        }
        if ("neXtProt".equalsIgnoreCase(databaseName)) {
            return NEXTPROT;
        }
        if ("Orphanet".equalsIgnoreCase(databaseName)) {
            return ORPHANET;
        }
        if ("PharmGKB".equalsIgnoreCase(databaseName)) {
            return PHARMGKB;
        }
        if ("PseudoCAP".equalsIgnoreCase(databaseName)) {
            return PSEUDOCAP;
        }
        if ("RGD".equalsIgnoreCase(databaseName)) {
            return RGD;
        }
        if ("SGD".equalsIgnoreCase(databaseName)) {
            return SGD;
        }
        if ("TAIR".equalsIgnoreCase(databaseName)) {
            return TAIR;
        }
        if ("TubercuList".equalsIgnoreCase(databaseName)) {
            return TUBERCULIST;
        }
        if ("WormBase".equalsIgnoreCase(databaseName)) {
            return WORMBASE;
        }
        if ("Xenbase".equalsIgnoreCase(databaseName)) {
            return XENBASE;
        }
        if ("ZFIN".equalsIgnoreCase(databaseName)) {
            return ZFIN;
        }
        if ("eggNOG".equalsIgnoreCase(databaseName)) {
            return EGGNOG;
        }
        if ("GeneTree".equalsIgnoreCase(databaseName)) {
            return GENETREE;
        }
        if ("HOGENOM".equalsIgnoreCase(databaseName)) {
            return HOGENOM;
        }
        if ("HOVERGEN".equalsIgnoreCase(databaseName)) {
            return HOVERGEN;
        }
        if ("InParanoid".equalsIgnoreCase(databaseName)) {
            return INPARANOID;
        }
        if ("OMA".equalsIgnoreCase(databaseName)) {
            return OMA;
        }
        if ("OrthoDB".equalsIgnoreCase(databaseName)) {
            return ORTHODB;
        }
        if ("PhylomeDB".equalsIgnoreCase(databaseName)) {
            return PHYLOMEDB;
        }
        if ("ProtClustDB".equalsIgnoreCase(databaseName)) {
            return PROTCLUSTDB;
        }
        if ("BioCyc".equalsIgnoreCase(databaseName)) {
            return BIOCYC;
        }
        if ("BRENDA".equalsIgnoreCase(databaseName)) {
            return BRENDA;
        }
        if ("Pathway_Interaction_DB".equalsIgnoreCase(databaseName)) {
            return PATHWAYINTERACTIONDB;
        }
        if ("Reactome".equalsIgnoreCase(databaseName)) {
            return REACTOME;
        }
        if ("BindingDB".equalsIgnoreCase(databaseName)) {
            return BINDINGDB;
        }
        if ("DrugBank".equalsIgnoreCase(databaseName)) {
            return DRUGBANK;
        }
        if ("NextBio".equalsIgnoreCase(databaseName)) {
            return NEXTBIO;
        }
        if ("PMAP-CutDB".equalsIgnoreCase(databaseName)) {
            return PMAPCUTDB;
        }
        if ("ArrayExpress".equalsIgnoreCase(databaseName)) {
            return ARRAYEXPRESS;
        }
        if ("Bgee".equalsIgnoreCase(databaseName)) {
            return BGEE;
        }
        if ("CleanEx".equalsIgnoreCase(databaseName)) {
            return CLEANEX;
        }
        if ("Genevestigator".equalsIgnoreCase(databaseName)) {
            return GENEVESTIGATOR;
        }
        if ("GermOnline".equalsIgnoreCase(databaseName)) {
            return GERMONLINE;
        }
        if ("Go".equalsIgnoreCase(databaseName)) {
            return GO;
        }
        if ("HAMAP".equalsIgnoreCase(databaseName)) {
            return HAMAP;
        }
        if ("InterPro".equalsIgnoreCase(databaseName)) {
            return INTERPRO;
        }
        if ("Gene3D".equalsIgnoreCase(databaseName)) {
            return GENE3D;
        }
        if ("KO".equalsIgnoreCase(databaseName)) {
            return KO;
        }
        if ("PANTHER".equalsIgnoreCase(databaseName)) {
            return PANTHER;
        }
        if ("Pfam".equalsIgnoreCase(databaseName)) {
            return PFAM;
        }
        if ("PIRSF".equalsIgnoreCase(databaseName)) {
            return PIRSF;
        }
        if ("PRINTS".equalsIgnoreCase(databaseName)) {
            return PRINTS;
        }
        if ("ProDom".equalsIgnoreCase(databaseName)) {
            return PRODOM;
        }
        if ("SMART".equalsIgnoreCase(databaseName)) {
            return SMART;
        }
        if ("SUPFAM".equalsIgnoreCase(databaseName)) {
            return SUPFAM;
        }
        if ("TIGRFAMs".equalsIgnoreCase(databaseName)) {
            return TIGRFAMS;
        }
        if ("PROSITE".equalsIgnoreCase(databaseName)) {
            return PROSITE;
        }
        if ("TRANSFAC".equalsIgnoreCase(databaseName)) {
            return TRANSFAC;
        }
        if ("HSC-2DPAGE".equalsIgnoreCase(databaseName)) {
            return HSC2DPAGE;
        }
        if ("BuruList".equalsIgnoreCase(databaseName)) {
            return BURULIST;
        }
        if ("HIV".equalsIgnoreCase(databaseName)) {
            return HIV;
        }
        if ("ListiList".equalsIgnoreCase(databaseName)) {
            return LISTILIST;
        }
        if ("MypuList".equalsIgnoreCase(databaseName)) {
            return MYPULIST;
        }
        if ("PhotoList".equalsIgnoreCase(databaseName)) {
            return PHOTOLIST;
        }
        if ("SagaList".equalsIgnoreCase(databaseName)) {
            return SAGALIST;
        }
        if ("StyGene".equalsIgnoreCase(databaseName)) {
            return STYGENE;
        }
        if ("SubtiList".equalsIgnoreCase(databaseName)) {
            return SUBTILIST;
        }
        if ("WormPep".equalsIgnoreCase(databaseName)) {
            return WORMPEP;
        }
        if ("LinkHub".equalsIgnoreCase(databaseName)) {
            return LINKHUB;
        }
        if ("Maize-2DPAGE".equalsIgnoreCase(databaseName)) {
            return MAIZE2DPAGE;
        }
        if ("RZPD-ProtExp".equalsIgnoreCase(databaseName)) {
            return RZPDPROTEXP;
        }
        if ("UniPep".equalsIgnoreCase(databaseName)) {
            return UNIPEP;
        }
        if ("Gcrdb".equalsIgnoreCase(databaseName)) {
            return GCRDB;
        }
        if ("CarbBank".equalsIgnoreCase(databaseName)) {
            return CARBBANK;
        }
        if ("Genew".equalsIgnoreCase(databaseName)) {
            return GENEW;
        }
        if ("GK".equalsIgnoreCase(databaseName)) {
            return GK;
        }
        if ("MaizeDB".equalsIgnoreCase(databaseName)) {
            return MAIZEDB;
        }
        if ("Mendel".equalsIgnoreCase(databaseName)) {
            return MENDEL;
        }
        if ("MGD".equalsIgnoreCase(databaseName)) {
            return MGD;
        }
        if ("YEPD".equalsIgnoreCase(databaseName)) {
            return YEPD;
        }
        return UNKNOWN;
    }
}

