/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.prediction;

public enum PredictiveModelType {
    INTERPRO("InterPro", "IPR"),
    BLAST("Blast", "B"),
    SPEARMINT("Spearmint", "SPM"),
    SAAS("SAAS", "SAAS"),
    XANTHIPPE("Xanthippe", "X"),
    RULEBASE("RuleBase", "RB"),
    HAMAP("HAMAP", "HAMAP"),
    PIRSR("PIRSR", "PIRSR"),
    PIRNR("PIRNR", "PIRNR"),
    UNKNOWN("UNKNOWN", "unknown"),
    UNIRULE("UNIRULE", "UR");

    private String value;
    private String dbCode;

    private PredictiveModelType(String value, String dbCode) {
        this.value = value;
        this.dbCode = dbCode;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    public String getDbCode() {
        return this.dbCode;
    }

    public static PredictiveModelType typeOf(String value) {
        for (PredictiveModelType predictiveModelType : PredictiveModelType.values()) {
            if (!predictiveModelType.getValue().equalsIgnoreCase(value)) continue;
            return predictiveModelType;
        }
        throw new IllegalArgumentException("the PredictiveModelType with the description " + value + " doesn't exist");
    }

    public static PredictiveModelType typeOfDbCode(String dbcode) {
        for (PredictiveModelType type : PredictiveModelType.values()) {
            if (!type.getDbCode().equals(dbcode)) continue;
            return type;
        }
        throw new IllegalArgumentException("the PredictiveModelType with the dbcode " + dbcode + " doesn't exist");
    }
}

