/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.prediction;

import uk.ac.ebi.kraken.interfaces.prediction.PredictionClassification;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;

public enum PredictionType {
    KEYWORD("KEYWORD", PredictionClassification.KEYWORD),
    EC_NUMBER("ECNUMBER", PredictionClassification.UNCLASSIFIED),
    PROTEINNAME("PROTEINNAME", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_RECOMMENDED_FULL("PROTEINNAME_RECOMMENDED_FULL", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_RECOMMENDED_SHORT("PROTEINNAME_RECOMMENDED_SHORT", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_RECOMMENDED_ALLERGEN("PROTEINNAME_RECOMMENDED_ALLERGEN", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_RECOMMENDED_BIOTECH("PROTEINNAME_RECOMMENDED_BIOTECH", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_RECOMMENDED_CD_ANTIGEN("PROTEINNAME_RECOMMENDED_CD_ANTIGEN", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_RECOMMENDED_EC("PROTEINNAME_RECOMMENDED_EC", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_RECOMMENDED_INN("PROTEINNAME_RECOMMENDED_INN", PredictionClassification.PROTEIN_NAME),
    PROTEINNAME_ALTERNATIVE_FULL("PROTEINNAME_ALTERNATIVE_FULL", PredictionClassification.PROTEIN_NAME),
    COMMENT("COMMENT", PredictionClassification.COMMENT),
    COMMENT_FUNCTION("COMMENT_FUNCTION", PredictionClassification.COMMENT),
    COMMENT_CATALYTIC_ACTIVITY("COMMENT_CATALYTIC_ACTIVITY", PredictionClassification.COMMENT),
    COMMENT_COFACTOR("COMMENT_COFACTOR", PredictionClassification.COMMENT),
    COMMENT_PATHWAY("COMMENT_PATHWAY", PredictionClassification.COMMENT),
    COMMENT_SUBUNIT("COMMENT_SUBUNIT", PredictionClassification.COMMENT),
    COMMENT_SUBCELLULAR_LOCATION("COMMENT_SUBCELLULAR_LOCATION", PredictionClassification.COMMENT),
    COMMENT_SIMILARITY("COMMENT_SIMILARITY", PredictionClassification.COMMENT),
    COMMENT_PAGE("COMMENT_PAGE", PredictionClassification.COMMENT),
    COMMENT_ENZYME_REGULATION("COMMENT_ENZYME_REGULATION", PredictionClassification.COMMENT),
    COMMENT_ALTERNATIVE_PRODUCTS("COMMENT_ALTERNATIVE_PRODUCTS", PredictionClassification.COMMENT),
    COMMENT_TISSUE_SPECIFICITY("COMMENT_TISSUE_SPECIFICITY", PredictionClassification.COMMENT),
    COMMENT_INDUCTION("COMMENT_INDUCTION", PredictionClassification.COMMENT),
    COMMENT_DOMAIN("COMMENT_DOMAIN", PredictionClassification.COMMENT),
    COMMENT_PTM("COMMENT_PTM", PredictionClassification.COMMENT),
    COMMENT_POLYMORPHISM("COMMENT_POLYMORPHISM", PredictionClassification.COMMENT),
    COMMENT_DISEASE("COMMENT_DISEASE", PredictionClassification.COMMENT),
    COMMENT_MISCELLANEOUS("COMMENT_MISCELLANEOUS", PredictionClassification.COMMENT),
    COMMENT_CAUTION("COMMENT_CAUTION", PredictionClassification.COMMENT),
    COMMENT_INTERACTION("COMMENT_INTERACTION", PredictionClassification.COMMENT),
    COMMENT_DEVELOPMENTAL_STAGE("COMMENT_DEVELOPMENTAL_STAGE", PredictionClassification.COMMENT),
    COMMENT_SEQUENCE_CAUTION("COMMENT_SEQUENCE_CAUTION", PredictionClassification.COMMENT),
    COMMENT_WEB_RESOURCE("COMMENT_WEB_RESOURCE", PredictionClassification.COMMENT),
    COMMENT_BIOPHYSICOCHEMICAL_PROPERTIES("COMMENT_BIOPHYSICOCHEMICAL_PROPERTIES", PredictionClassification.COMMENT),
    COMMENT_MASS_SPECTROMETRY("COMMENT_MASS_SPECTROMETRY", PredictionClassification.COMMENT),
    COMMENT_DISRUPTION_PHENOTYPE("COMMENT_DISRUPTION_PHENOTYPE", PredictionClassification.COMMENT),
    COMMENT_RNA_EDITING("COMMENT_RNA_EDITING", PredictionClassification.COMMENT),
    COMMENT_BIOTECHNOLOGY("COMMENT_BIOTECHNOLOGY", PredictionClassification.COMMENT),
    COMMENT_PHARMACEUTICAL("COMMENT_PHARMACEUTICAL", PredictionClassification.COMMENT),
    GENE_NAME("GENE_NAME", PredictionClassification.GENE_NAME),
    GENE_NAME_NAME("GENE_NAME_NAME", PredictionClassification.GENE_NAME),
    GENE_NAME_SYNONYMS("GENE_NAME_SYNONYMS", PredictionClassification.GENE_NAME),
    GENE_NAME_ORDEREDLOCUSNAMES("GENE_NAME_ORDEREDLOCUSNAMES", PredictionClassification.GENE_NAME),
    GENE_NAME_ORFNAMES("GENE_NAME_ORFNAMES", PredictionClassification.GENE_NAME),
    FEATURE("FEATURE", PredictionClassification.FEATURE),
    FEATURE_ACT_SITE("FEATURE_ACT_SITE", PredictionClassification.FEATURE),
    FEATURE_BINDING("FEATURE_BINDING", PredictionClassification.FEATURE),
    FEATURE_CARBOHYD("FEATURE_CARBOHYD", PredictionClassification.FEATURE),
    FEATURE_CHAIN("FEATURE_CHAIN", PredictionClassification.FEATURE),
    FEATURE_COILED("FEATURE_COILED", PredictionClassification.FEATURE),
    FEATURE_COMPBIAS("FEATURE_COMPBIAS", PredictionClassification.FEATURE),
    FEATURE_CONFLICT("FEATURE_CONFLICT", PredictionClassification.FEATURE),
    FEATURE_CROSSLNK("FEATURE_CROSSLNK", PredictionClassification.FEATURE),
    FEATURE_DISULFID("FEATURE_DISULFID", PredictionClassification.FEATURE),
    FEATURE_DNA_BIND("FEATURE_DNA_BIND", PredictionClassification.FEATURE),
    FEATURE_DOMAIN("FEATURE_DOMAIN", PredictionClassification.FEATURE),
    FEATURE_HELIX("FEATURE_HELIX", PredictionClassification.FEATURE),
    FEATURE_INIT_MET("FEATURE_INIT_MET", PredictionClassification.FEATURE),
    FEATURE_LIPID("FEATURE_LIPID", PredictionClassification.FEATURE),
    FEATURE_METAL("FEATURE_METAL", PredictionClassification.FEATURE),
    FEATURE_MOD_RES("FEATURE_MOD_RES", PredictionClassification.FEATURE),
    FEATURE_MOTIF("FEATURE_MOTIF", PredictionClassification.FEATURE),
    FEATURE_MUTAGEN("FEATURE_MUTAGEN", PredictionClassification.FEATURE),
    FEATURE_NON_STD("FEATURE_NON_STD", PredictionClassification.FEATURE),
    FEATURE_NP_BIND("FEATURE_NP_BIND", PredictionClassification.FEATURE),
    FEATURE_PEPTIDE("FEATURE_PEPTIDE", PredictionClassification.FEATURE),
    FEATURE_PROPEP("FEATURE_PROPEP", PredictionClassification.FEATURE),
    FEATURE_REGION("FEATURE_REGION", PredictionClassification.FEATURE),
    FEATURE_REPEAT("FEATURE_REPEAT", PredictionClassification.FEATURE),
    FEATURE_SIGNAL("FEATURE_SIGNAL", PredictionClassification.FEATURE),
    FEATURE_SITE("FEATURE_SITE", PredictionClassification.FEATURE),
    FEATURE_STRAND("FEATURE_STRAND", PredictionClassification.FEATURE),
    FEATURE_TOPO_DOM("FEATURE_TOPO_DOM", PredictionClassification.FEATURE),
    FEATURE_TRANSIT("FEATURE_TRANSIT", PredictionClassification.FEATURE),
    FEATURE_TRANSMEM("FEATURE_TRANSMEM", PredictionClassification.FEATURE),
    FEATURE_TURN("FEATURE_TURN", PredictionClassification.FEATURE),
    FEATURE_UNSURE("FEATURE_UNSURE", PredictionClassification.FEATURE),
    FEATURE_VARIANT("FEATURE_VARIANT", PredictionClassification.FEATURE),
    FEATURE_VAR_SEQ("FEATURE_VAR_SEQ", PredictionClassification.FEATURE),
    FEATURE_ZN_FING("FEATURE_ZN_FING", PredictionClassification.FEATURE),
    FEATURE_INTRAMEM("FEATURE_INTRAMEM", PredictionClassification.FEATURE),
    XREF_GO("XREF_GO", PredictionClassification.CROSS_REFERENCE),
    UNKNOWN("UNKNOWN", PredictionClassification.FEATURE);

    private String value;
    private String displayName;
    private PredictionClassification classification;

    private PredictionType(String value, String displayName, PredictionClassification predictionClassification) {
        this.value = value;
        this.displayName = displayName;
        this.classification = predictionClassification;
    }

    private PredictionType(String type, PredictionClassification predictionClassification) {
        this(type, type, predictionClassification);
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static PredictionType typeOf(String value) {
        for (PredictionType predictiveModelType : PredictionType.values()) {
            if (!predictiveModelType.getValue().equalsIgnoreCase(value)) continue;
            return predictiveModelType;
        }
        throw new IllegalArgumentException("the PredictionType with the description " + value + " doesn't exist");
    }

    public static PredictionType nameOf(String value) {
        for (PredictionType predictiveModelType : PredictionType.values()) {
            if (!predictiveModelType.getDisplayName().contains(value.replace(" ", "_"))) continue;
            return predictiveModelType;
        }
        throw new IllegalArgumentException("the PredictionType " + value + " doesn't exist");
    }

    public static boolean isKeywordPrediction(PredictionType predictionType) {
        switch (predictionType) {
            case KEYWORD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCommentPrediction(PredictionType predictionType) {
        switch (predictionType) {
            case COMMENT: 
            case COMMENT_FUNCTION: 
            case COMMENT_CATALYTIC_ACTIVITY: 
            case COMMENT_COFACTOR: 
            case COMMENT_PATHWAY: 
            case COMMENT_SUBUNIT: 
            case COMMENT_SUBCELLULAR_LOCATION: 
            case COMMENT_SIMILARITY: 
            case COMMENT_PAGE: 
            case COMMENT_ENZYME_REGULATION: 
            case COMMENT_ALTERNATIVE_PRODUCTS: 
            case COMMENT_TISSUE_SPECIFICITY: 
            case COMMENT_DEVELOPMENTAL_STAGE: 
            case COMMENT_INDUCTION: 
            case COMMENT_DOMAIN: 
            case COMMENT_PTM: 
            case COMMENT_POLYMORPHISM: 
            case COMMENT_DISEASE: 
            case COMMENT_MISCELLANEOUS: 
            case COMMENT_CAUTION: 
            case COMMENT_INTERACTION: 
            case COMMENT_SEQUENCE_CAUTION: 
            case COMMENT_WEB_RESOURCE: 
            case COMMENT_BIOPHYSICOCHEMICAL_PROPERTIES: 
            case COMMENT_MASS_SPECTROMETRY: 
            case COMMENT_DISRUPTION_PHENOTYPE: 
            case COMMENT_RNA_EDITING: 
            case COMMENT_BIOTECHNOLOGY: 
            case COMMENT_PHARMACEUTICAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isProteinNamePrediction(PredictionType predictionType) {
        switch (predictionType) {
            case PROTEINNAME: 
            case PROTEINNAME_RECOMMENDED_ALLERGEN: 
            case PROTEINNAME_RECOMMENDED_BIOTECH: 
            case PROTEINNAME_RECOMMENDED_CD_ANTIGEN: 
            case PROTEINNAME_RECOMMENDED_EC: 
            case PROTEINNAME_RECOMMENDED_FULL: 
            case PROTEINNAME_RECOMMENDED_INN: 
            case PROTEINNAME_RECOMMENDED_SHORT: 
            case PROTEINNAME_ALTERNATIVE_FULL: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEcNamePrediction(PredictionType predictionType) {
        switch (predictionType) {
            case PROTEINNAME_RECOMMENDED_EC: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFeaturePrediction(PredictionType predictionType) {
        switch (predictionType) {
            case FEATURE: 
            case FEATURE_ACT_SITE: 
            case FEATURE_BINDING: 
            case FEATURE_CARBOHYD: 
            case FEATURE_CHAIN: 
            case FEATURE_COILED: 
            case FEATURE_COMPBIAS: 
            case FEATURE_CONFLICT: 
            case FEATURE_CROSSLNK: 
            case FEATURE_DISULFID: 
            case FEATURE_DNA_BIND: 
            case FEATURE_DOMAIN: 
            case FEATURE_HELIX: 
            case FEATURE_INIT_MET: 
            case FEATURE_LIPID: 
            case FEATURE_METAL: 
            case FEATURE_MOD_RES: 
            case FEATURE_MOTIF: 
            case FEATURE_MUTAGEN: 
            case FEATURE_NON_STD: 
            case FEATURE_NP_BIND: 
            case FEATURE_PEPTIDE: 
            case FEATURE_PROPEP: 
            case FEATURE_REGION: 
            case FEATURE_REPEAT: 
            case FEATURE_SIGNAL: 
            case FEATURE_SITE: 
            case FEATURE_STRAND: 
            case FEATURE_TOPO_DOM: 
            case FEATURE_TRANSIT: 
            case FEATURE_TRANSMEM: 
            case FEATURE_TURN: 
            case FEATURE_UNSURE: 
            case FEATURE_VAR_SEQ: 
            case FEATURE_VARIANT: 
            case FEATURE_ZN_FING: 
            case FEATURE_INTRAMEM: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGeneNamePrediction(PredictionType predictionType) {
        switch (predictionType) {
            case GENE_NAME: 
            case GENE_NAME_NAME: 
            case GENE_NAME_SYNONYMS: 
            case GENE_NAME_ORDEREDLOCUSNAMES: 
            case GENE_NAME_ORFNAMES: {
                return true;
            }
        }
        return false;
    }

    public static PredictionType convertProteinNameFieldsIntoPredictionType(NameType nameType, FieldType fieldType) {
        switch (nameType) {
            case RECNAME: {
                switch (fieldType) {
                    case ALLERGEN: {
                        return PROTEINNAME_RECOMMENDED_ALLERGEN;
                    }
                    case BIOTECH: {
                        return PROTEINNAME_RECOMMENDED_BIOTECH;
                    }
                    case CD_ANTIGEN: {
                        return PROTEINNAME_RECOMMENDED_CD_ANTIGEN;
                    }
                    case EC: {
                        return PROTEINNAME_RECOMMENDED_EC;
                    }
                    case FULL: {
                        return PROTEINNAME_RECOMMENDED_FULL;
                    }
                    case INN: {
                        return PROTEINNAME_RECOMMENDED_INN;
                    }
                    case SHORT: {
                        return PROTEINNAME_RECOMMENDED_SHORT;
                    }
                }
            }
            case ALTNAME: {
                switch (fieldType) {
                    case FULL: {
                        return PROTEINNAME_ALTERNATIVE_FULL;
                    }
                }
            }
        }
        return UNKNOWN;
    }

    public static PredictionType convertCommentIntoPredictionType(CommentType type) {
        switch (type) {
            case FUNCTION: {
                return COMMENT_FUNCTION;
            }
            case CATALYTIC_ACTIVITY: {
                return COMMENT_CATALYTIC_ACTIVITY;
            }
            case COFACTOR: {
                return COMMENT_COFACTOR;
            }
            case PATHWAY: {
                return COMMENT_PATHWAY;
            }
            case SUBUNIT: {
                return COMMENT_SUBUNIT;
            }
            case SUBCELLULAR_LOCATION: {
                return COMMENT_SUBCELLULAR_LOCATION;
            }
            case SIMILARITY: {
                return COMMENT_SIMILARITY;
            }
            case PAGE: {
                return COMMENT_PAGE;
            }
            case ENZYME_REGULATION: {
                return COMMENT_ENZYME_REGULATION;
            }
            case ALTERNATIVE_PRODUCTS: {
                return COMMENT_ALTERNATIVE_PRODUCTS;
            }
            case TISSUE_SPECIFICITY: {
                return COMMENT_TISSUE_SPECIFICITY;
            }
            case INDUCTION: {
                return COMMENT_INDUCTION;
            }
            case DOMAIN: {
                return COMMENT_DOMAIN;
            }
            case PTM: {
                return COMMENT_PTM;
            }
            case POLYMORPHISM: {
                return COMMENT_POLYMORPHISM;
            }
            case DISEASE: {
                return COMMENT_DISEASE;
            }
            case MISCELLANEOUS: {
                return COMMENT_MISCELLANEOUS;
            }
            case CAUTION: {
                return COMMENT_CAUTION;
            }
            case INTERACTION: {
                return COMMENT_INTERACTION;
            }
            case DEVELOPMENTAL_STAGE: {
                return COMMENT_DEVELOPMENTAL_STAGE;
            }
            case SEQUENCE_CAUTION: {
                return COMMENT_SEQUENCE_CAUTION;
            }
            case WEBRESOURCE: {
                return COMMENT_WEB_RESOURCE;
            }
            case BIOPHYSICOCHEMICAL_PROPERTIES: {
                return COMMENT_BIOPHYSICOCHEMICAL_PROPERTIES;
            }
            case MASS_SPECTROMETRY: {
                return COMMENT_MASS_SPECTROMETRY;
            }
            case DISRUPTION_PHENOTYPE: {
                return COMMENT_DISRUPTION_PHENOTYPE;
            }
            case RNA_EDITING: {
                return COMMENT_RNA_EDITING;
            }
            case BIOTECHNOLOGY: {
                return COMMENT_BIOTECHNOLOGY;
            }
            case PHARMACEUTICAL: {
                return COMMENT_PHARMACEUTICAL;
            }
        }
        return UNKNOWN;
    }

    public static CommentType convertCommentPredictionTypeToField(PredictionType predictionType) {
        switch (predictionType) {
            case COMMENT_FUNCTION: {
                return CommentType.FUNCTION;
            }
            case COMMENT_CATALYTIC_ACTIVITY: {
                return CommentType.CATALYTIC_ACTIVITY;
            }
            case COMMENT_COFACTOR: {
                return CommentType.COFACTOR;
            }
            case COMMENT_PATHWAY: {
                return CommentType.PATHWAY;
            }
            case COMMENT_SUBUNIT: {
                return CommentType.SUBUNIT;
            }
            case COMMENT_SUBCELLULAR_LOCATION: {
                return CommentType.SUBCELLULAR_LOCATION;
            }
            case COMMENT_SIMILARITY: {
                return CommentType.SIMILARITY;
            }
            case COMMENT_PAGE: {
                return CommentType.PAGE;
            }
            case COMMENT_ENZYME_REGULATION: {
                return CommentType.ENZYME_REGULATION;
            }
            case COMMENT_ALTERNATIVE_PRODUCTS: {
                return CommentType.ALTERNATIVE_PRODUCTS;
            }
            case COMMENT_TISSUE_SPECIFICITY: {
                return CommentType.TISSUE_SPECIFICITY;
            }
            case COMMENT_DEVELOPMENTAL_STAGE: {
                return CommentType.DEVELOPMENTAL_STAGE;
            }
            case COMMENT_INDUCTION: {
                return CommentType.INDUCTION;
            }
            case COMMENT_DOMAIN: {
                return CommentType.DOMAIN;
            }
            case COMMENT_PTM: {
                return CommentType.PTM;
            }
            case COMMENT_POLYMORPHISM: {
                return CommentType.POLYMORPHISM;
            }
            case COMMENT_DISEASE: {
                return CommentType.DISEASE;
            }
            case COMMENT_MISCELLANEOUS: {
                return CommentType.MISCELLANEOUS;
            }
            case COMMENT_CAUTION: {
                return CommentType.CAUTION;
            }
            case COMMENT_INTERACTION: {
                return CommentType.INTERACTION;
            }
            case COMMENT_SEQUENCE_CAUTION: {
                return CommentType.SEQUENCE_CAUTION;
            }
            case COMMENT_WEB_RESOURCE: {
                return CommentType.WEBRESOURCE;
            }
            case COMMENT_BIOPHYSICOCHEMICAL_PROPERTIES: {
                return CommentType.BIOPHYSICOCHEMICAL_PROPERTIES;
            }
            case COMMENT_MASS_SPECTROMETRY: {
                return CommentType.MASS_SPECTROMETRY;
            }
            case COMMENT_DISRUPTION_PHENOTYPE: {
                return CommentType.DISRUPTION_PHENOTYPE;
            }
            case COMMENT_RNA_EDITING: {
                return CommentType.RNA_EDITING;
            }
            case COMMENT_BIOTECHNOLOGY: {
                return CommentType.BIOTECHNOLOGY;
            }
            case COMMENT_PHARMACEUTICAL: {
                return CommentType.PHARMACEUTICAL;
            }
        }
        return null;
    }

    public PredictionClassification getClassification() {
        return this.classification;
    }

    public static class ConvertProteinNamePredictionTypeToFields {
        public static NameType getProteinNameFromPredictionType(PredictionType predictionType) {
            switch (predictionType) {
                case PROTEINNAME_RECOMMENDED_ALLERGEN: 
                case PROTEINNAME_RECOMMENDED_BIOTECH: 
                case PROTEINNAME_RECOMMENDED_CD_ANTIGEN: 
                case PROTEINNAME_RECOMMENDED_EC: 
                case PROTEINNAME_RECOMMENDED_FULL: 
                case PROTEINNAME_RECOMMENDED_INN: 
                case PROTEINNAME_RECOMMENDED_SHORT: {
                    return NameType.RECNAME;
                }
                case PROTEINNAME_ALTERNATIVE_FULL: {
                    return NameType.ALTNAME;
                }
            }
            return NameType.UNKNOWN;
        }

        public static FieldType getProteinNameFieldFromPredictionType(PredictionType predictionType) {
            switch (predictionType) {
                case PROTEINNAME_RECOMMENDED_ALLERGEN: {
                    return FieldType.ALLERGEN;
                }
                case PROTEINNAME_RECOMMENDED_BIOTECH: {
                    return FieldType.BIOTECH;
                }
                case PROTEINNAME_RECOMMENDED_CD_ANTIGEN: {
                    return FieldType.CD_ANTIGEN;
                }
                case PROTEINNAME_RECOMMENDED_EC: {
                    return FieldType.EC;
                }
                case PROTEINNAME_RECOMMENDED_FULL: 
                case PROTEINNAME_ALTERNATIVE_FULL: {
                    return FieldType.FULL;
                }
                case PROTEINNAME_RECOMMENDED_INN: {
                    return FieldType.INN;
                }
                case PROTEINNAME_RECOMMENDED_SHORT: {
                    return FieldType.SHORT;
                }
            }
            return FieldType.UNKNOWN;
        }
    }
}

