/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.interpro;

public enum InterProType {
    ACTIVE_SITE("Active site", "A"),
    BINDING_SITE("Binding site", "B"),
    CONSERVED_SITE("Conserved site", "C"),
    DOMAIN("Domain", "D"),
    FAMILY("Family", "F"),
    PTM("PTM", "P"),
    REPEAT("Repeat", "R"),
    UNKNOWN("UNKNOWN", "U"),
    POSTTRANSLATIONAL_MODIFICATION("PTM", "ptm"),
    PMT_SITE("PMT Site", "PS"),
    UNINTEGRATED("unintegrated", "unintegrated"),
    GO("GO", "G");

    private String value;
    private String dbcode;

    private InterProType(String type, String dbCode) {
        this.value = type;
        this.dbcode = dbCode;
    }

    public String getValue() {
        return this.value;
    }

    public String getDbcode() {
        return this.dbcode;
    }

    public static InterProType typeOfDbCode(String dbcode) {
        for (InterProType type : InterProType.values()) {
            if (!type.getDbcode().equals(dbcode)) continue;
            return type;
        }
        if ("na".equals(dbcode)) {
            return UNKNOWN;
        }
        throw new IllegalArgumentException("the InterProType with the dbcode " + dbcode + " doesn't exist");
    }

    public static InterProType typeOf(String value) {
        for (InterProType type : InterProType.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        throw new IllegalArgumentException("the InterProType with the description " + value + " doesn't exist");
    }
}

