/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.interfaces.go;

public enum GoAnnotationEvidence {
    IMP("inferred from mutant phenotype", "IMP", "ECO:0000015"),
    IGI("inferred from genetic interaction", "IGI", "ECO:0000011"),
    IGC("inferred from genomic context", "IGC", "ECO:0000177"),
    IPI("inferred from physical interaction", "IPI", "ECO:0000021"),
    ISS("inferred from sequence similarity", "ISS", "ECO:0000044"),
    IDA("inferred from direct assay", "IDA", "ECO:0000002"),
    IEP("inferred from expression pattern", "IEP", "ECO:0000008"),
    ISA("inferred from sequence alignment", "ISA", "ECO:0000200"),
    IEA("inferred from electronic annotation", "IEA", "ECO:0000203"),
    TAS("traceable author statement", "TAS", "ECO:0000033"),
    NAS("non-traceable author statement", "NAS", "ECO:0000034"),
    EXP("inferred from experiment", "EXP", "ECO:0000006"),
    NR("not recorded", "NR", "ECO:0000037"),
    ND("no biological data", "ND", "ECO:0000035"),
    IC("inferred by curator", "IC", "ECO:0000001"),
    RCA("inferred from reviewed computational analysis", "RCA", "ECO:0000053"),
    IBA("Inferred from Biological aspect of Ancestor", "IBA", "ECO:");

    private String name;
    private String code;
    private String cvId;

    private GoAnnotationEvidence(String type, String code, String cvId) {
        this.name = type;
        this.code = code;
        this.cvId = cvId;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getCvId() {
        return this.cvId;
    }

    public static GoAnnotationEvidence typeOf(String code) {
        for (GoAnnotationEvidence type : GoAnnotationEvidence.values()) {
            if (!type.getCode().equals(code)) continue;
            return type;
        }
        throw new IllegalArgumentException("the GoAnnotationEvidence with the db Code " + code + " doesn't exist");
    }
}

