/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.jaxrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.Stub;
import javax.xml.rpc.soap.SOAPFaultException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.jaxrpc.JaxRpcSoapFaultException;
import org.springframework.remoting.jaxrpc.LocalJaxRpcServiceFactory;
import org.springframework.remoting.rmi.RmiClientInterceptorUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JaxRpcPortClientInterceptor
extends LocalJaxRpcServiceFactory
implements MethodInterceptor,
InitializingBean {
    private Service jaxRpcService;
    private Service serviceToUse;
    private String portName;
    private String username;
    private String password;
    private String endpointAddress;
    private boolean maintainSession;
    private final Map<String, Object> customPropertyMap = new HashMap<String, Object>();
    private Class serviceInterface;
    private Class portInterface;
    private boolean lookupServiceOnStartup = true;
    private boolean refreshServiceAfterConnectFailure = false;
    private QName portQName;
    private Remote portStub;
    private final Object preparationMonitor = new Object();

    public void setJaxRpcService(Service jaxRpcService) {
        this.jaxRpcService = jaxRpcService;
    }

    public Service getJaxRpcService() {
        return this.jaxRpcService;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setMaintainSession(boolean maintainSession) {
        this.maintainSession = maintainSession;
    }

    public boolean isMaintainSession() {
        return this.maintainSession;
    }

    public void setCustomProperties(Properties customProperties) {
        CollectionUtils.mergePropertiesIntoMap(customProperties, this.customPropertyMap);
    }

    public void setCustomPropertyMap(Map<String, Object> customProperties) {
        if (customProperties != null) {
            for (Map.Entry<String, Object> entry : customProperties.entrySet()) {
                this.addCustomProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    public Map<String, Object> getCustomPropertyMap() {
        return this.customPropertyMap;
    }

    public void addCustomProperty(String name, Object value) {
        this.customPropertyMap.put(name, value);
    }

    public void setServiceInterface(Class serviceInterface) {
        if (serviceInterface != null && !serviceInterface.isInterface()) {
            throw new IllegalArgumentException("'serviceInterface' must be an interface");
        }
        this.serviceInterface = serviceInterface;
    }

    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    public void setPortInterface(Class portInterface) {
        if (!(portInterface == null || portInterface.isInterface() && Remote.class.isAssignableFrom(portInterface))) {
            throw new IllegalArgumentException("'portInterface' must be an interface derived from [java.rmi.Remote]");
        }
        this.portInterface = portInterface;
    }

    public Class getPortInterface() {
        return this.portInterface;
    }

    public void setLookupServiceOnStartup(boolean lookupServiceOnStartup) {
        this.lookupServiceOnStartup = lookupServiceOnStartup;
    }

    public void setRefreshServiceAfterConnectFailure(boolean refreshServiceAfterConnectFailure) {
        this.refreshServiceAfterConnectFailure = refreshServiceAfterConnectFailure;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.lookupServiceOnStartup) {
            this.prepare();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws RemoteLookupFailureException {
        if (this.getPortName() == null) {
            throw new IllegalArgumentException("Property 'portName' is required");
        }
        Object object = this.preparationMonitor;
        synchronized (object) {
            this.serviceToUse = null;
            this.portQName = this.getQName(this.getPortName());
            try {
                Service service = this.getJaxRpcService();
                if (service == null) {
                    service = this.createJaxRpcService();
                } else {
                    this.postProcessJaxRpcService(service);
                }
                Class portInterface = this.getPortInterface();
                if (portInterface != null && !this.alwaysUseJaxRpcCall()) {
                    Class serviceInterface;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Creating JAX-RPC proxy for JAX-RPC port [" + this.portQName + "], using port interface [" + portInterface.getName() + "]");
                    }
                    Remote remoteObj = service.getPort(this.portQName, portInterface);
                    if (this.logger.isDebugEnabled() && (serviceInterface = this.getServiceInterface()) != null) {
                        boolean isImpl = serviceInterface.isInstance(remoteObj);
                        this.logger.debug("Using service interface [" + serviceInterface.getName() + "] for JAX-RPC port [" + this.portQName + "] - " + (!isImpl ? "not" : "") + " directly implemented");
                    }
                    if (!(remoteObj instanceof Stub)) {
                        throw new RemoteLookupFailureException("Port stub of class [" + remoteObj.getClass().getName() + "] is not a valid JAX-RPC stub: it does not implement interface [javax.xml.rpc.Stub]");
                    }
                    Stub stub = (Stub)((Object)remoteObj);
                    this.preparePortStub(stub);
                    this.postProcessPortStub(stub);
                    this.portStub = remoteObj;
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Using JAX-RPC dynamic calls for JAX-RPC port [" + this.portQName + "]");
                }
                this.serviceToUse = service;
            }
            catch (ServiceException ex) {
                throw new RemoteLookupFailureException("Failed to initialize service for JAX-RPC port [" + this.portQName + "]", ex);
            }
        }
    }

    protected boolean alwaysUseJaxRpcCall() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        Object object = this.preparationMonitor;
        synchronized (object) {
            this.serviceToUse = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isPrepared() {
        Object object = this.preparationMonitor;
        synchronized (object) {
            return this.serviceToUse != null;
        }
    }

    protected final QName getPortQName() {
        return this.portQName;
    }

    protected void preparePortStub(Stub stub) {
        String endpointAddress;
        String password;
        String username = this.getUsername();
        if (username != null) {
            stub._setProperty("javax.xml.rpc.security.auth.username", username);
        }
        if ((password = this.getPassword()) != null) {
            stub._setProperty("javax.xml.rpc.security.auth.password", password);
        }
        if ((endpointAddress = this.getEndpointAddress()) != null) {
            stub._setProperty("javax.xml.rpc.service.endpoint.address", endpointAddress);
        }
        if (this.isMaintainSession()) {
            stub._setProperty("javax.xml.rpc.session.maintain", Boolean.TRUE);
        }
        if (this.customPropertyMap != null) {
            for (Map.Entry<String, Object> entry : this.customPropertyMap.entrySet()) {
                stub._setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void postProcessPortStub(Stub stub) {
    }

    protected Remote getPortStub() {
        return this.portStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (AopUtils.isToStringMethod(invocation.getMethod())) {
            return "JAX-RPC proxy for port [" + this.getPortName() + "] of service [" + this.getServiceName() + "]";
        }
        Object object = this.preparationMonitor;
        synchronized (object) {
            if (!this.isPrepared()) {
                this.prepare();
            }
        }
        return this.doInvoke(invocation);
    }

    protected Object doInvoke(MethodInvocation invocation) throws Throwable {
        Remote stub = this.getPortStub();
        try {
            if (stub != null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Invoking operation '" + invocation.getMethod().getName() + "' on JAX-RPC port stub");
                }
                return this.doInvoke(invocation, stub);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Invoking operation '" + invocation.getMethod().getName() + "' as JAX-RPC dynamic call");
            }
            return this.performJaxRpcCall(invocation, this.serviceToUse);
        }
        catch (RemoteException ex) {
            throw this.handleRemoteException(invocation.getMethod(), ex);
        }
        catch (SOAPFaultException ex) {
            throw new JaxRpcSoapFaultException(ex);
        }
        catch (JAXRPCException ex) {
            throw new RemoteProxyFailureException("Invalid JAX-RPC call configuration", ex);
        }
    }

    protected Object doInvoke(MethodInvocation invocation, Remote portStub) throws Throwable {
        try {
            return RmiClientInterceptorUtils.invokeRemoteMethod(invocation, portStub);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performJaxRpcCall(MethodInvocation invocation, Service service) throws Throwable {
        Method method = invocation.getMethod();
        QName portQName = this.portQName;
        Call call = null;
        Service service2 = service;
        synchronized (service2) {
            call = service.createCall(portQName, method.getName());
        }
        this.prepareJaxRpcCall(call);
        this.postProcessJaxRpcCall(call, invocation);
        return call.invoke(invocation.getArguments());
    }

    protected void prepareJaxRpcCall(Call call) {
        String endpointAddress;
        String password;
        String username = this.getUsername();
        if (username != null) {
            call.setProperty("javax.xml.rpc.security.auth.username", username);
        }
        if ((password = this.getPassword()) != null) {
            call.setProperty("javax.xml.rpc.security.auth.password", password);
        }
        if ((endpointAddress = this.getEndpointAddress()) != null) {
            call.setTargetEndpointAddress(endpointAddress);
        }
        if (this.isMaintainSession()) {
            call.setProperty("javax.xml.rpc.session.maintain", Boolean.TRUE);
        }
        if (this.customPropertyMap != null) {
            for (Map.Entry<String, Object> entry : this.customPropertyMap.entrySet()) {
                call.setProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void postProcessJaxRpcCall(Call call, MethodInvocation invocation) {
    }

    protected Throwable handleRemoteException(Method method, RemoteException ex) {
        Throwable cause;
        boolean isConnectFailure = this.isConnectFailure(ex);
        if (isConnectFailure && this.refreshServiceAfterConnectFailure) {
            this.reset();
        }
        if ((cause = ex.getCause()) != null && ReflectionUtils.declaresException(method, cause.getClass())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rethrowing wrapped exception of type [" + cause.getClass().getName() + "] as-is");
            }
            return ex.getCause();
        }
        return RmiClientInterceptorUtils.convertRmiAccessException(method, ex, isConnectFailure, this.portQName.toString());
    }

    protected boolean isConnectFailure(RemoteException ex) {
        return !ex.getClass().getName().contains("Fault") && !ex.getClass().getSuperclass().getName().contains("Fault");
    }
}

