/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.layer.InputSourceHandler;
import de.berlin.hu.wbi.common.layer.InputStreamHandler;
import de.berlin.hu.wbi.common.layer.TextHandler;
import de.berlin.hu.wbi.common.layer.XmlHandler;
import de.berlin.hu.wbi.common.xml.BridgeXmlHandler;
import de.berlin.hu.wbi.common.xml.XmlKit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlReader
implements InputStreamHandler,
TextHandler,
InputSourceHandler {
    private XMLReader xmlReader;
    private Matcher errorMatcher;
    private File file;

    public XmlReader(XmlHandler handler, XMLReader reader) {
        this.xmlReader = reader;
        this.errorMatcher = Pattern.compile("(.*)(\\s)([(]).*").matcher("");
        this.xmlReader.setContentHandler(new BridgeXmlHandler(handler));
    }

    public XmlReader(XmlHandler handler) throws SAXException {
        this(handler, XMLReaderFactory.createXMLReader());
    }

    public XMLReader getXmlReader() {
        return this.xmlReader;
    }

    public void handleInputSourceSource(InputSourceSource streamable) throws IOException, SAXException {
        try {
            this.xmlReader.parse(streamable.getInputSource());
        }
        catch (FileNotFoundException e) {
            this.createTemporaryDdtFile(e);
            this.handleInputSourceSource(streamable);
        }
    }

    @Override
    public void handleInputSource(InputSource input) throws Throwable {
        try {
            this.xmlReader.parse(input);
        }
        catch (FileNotFoundException e) {
            this.createTemporaryDdtFile(e);
            this.handleInputSource(input);
        }
    }

    @Override
    public void handleSystemId(String systemId) throws Throwable {
        this.handleInputSource(new InputSource(systemId));
    }

    public void createTemporaryDdtFile(FileNotFoundException e) throws IOException {
        String message = e.getMessage();
        System.out.println(message);
        this.errorMatcher.reset(message);
        if (this.errorMatcher.matches()) {
            String path = this.errorMatcher.group(1);
            this.file = new File(path);
            this.file.getParentFile().mkdirs();
            this.file.createNewFile();
            this.file.deleteOnExit();
            System.err.println("Created temporary file: " + this.file.getCanonicalPath());
        }
        throw e;
    }

    @Override
    public void handleText(CharSequence text) throws Throwable {
        InputSource input = XmlKit.getInputSource(text);
        this.handleInputSource(input);
    }

    @Override
    public void handleInputStream(InputStream input) throws Exception {
        this.xmlReader.parse(new InputSource(input));
    }

    public static interface InputSourceSource {
        public InputSource getInputSource();
    }
}

