/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.misc.StringBuilders;
import de.berlin.hu.wbi.common.xml.AdvancedXmlHandler;
import de.berlin.hu.wbi.common.xml.XmlReader;
import java.io.PrintStream;
import java.util.EnumSet;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;

public class XmlPrinter
extends AdvancedXmlHandler<AdvancedXmlHandler.Event> {
    private XMLStreamWriter output;
    private StringBuilder buffer = new StringBuilder();

    public XmlPrinter(PrintStream out) throws XMLStreamException, FactoryConfigurationError {
        super(EnumSet.noneOf(AdvancedXmlHandler.Event.class));
        XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(out);
        this.setOutput(writer);
        this.enable();
    }

    @Override
    public void handleStartDocument() throws Throwable {
        this.output.writeStartDocument();
        this.output.writeCharacters("\n");
    }

    @Override
    public void handleEndDocument() throws Throwable {
        this.output.writeEndDocument();
    }

    public void setOutput(XMLStreamWriter output) {
        this.output = output;
    }

    @Override
    public void handleStartElement(String uri, String localName, String qName, Attributes attributes) throws Throwable {
        super.handleStartElement(uri, localName, qName, attributes);
        if (this.buffer.length() > 0) {
            this.output.writeCharacters(this.buffer.toString());
            this.buffer.setLength(0);
            this.output.writeCharacters("\n");
        }
        this.output.writeComment(this.path.toString());
        this.output.writeCharacters("\n");
        this.output.writeStartElement((String)this.openElements.getLast());
        Attributes atts = (Attributes)this.attributesDeque.getLast();
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            String value = atts.getValue(i);
            this.output.writeAttribute(name, value);
        }
        this.output.writeCharacters("\n");
    }

    @Override
    public void handleCharacters(char[] ch, int start, int length) throws Throwable {
        super.handleCharacters(ch, start, length);
        this.buffer.append(ch, start, length);
    }

    @Override
    public void handleEndElement(String uri, String localName, String qName) throws Throwable {
        if (this.buffer.length() > 0) {
            this.output.writeCharacters(this.buffer.toString());
            this.buffer.setLength(0);
            this.output.writeCharacters("\n");
        }
        this.output.writeEndElement();
        this.output.writeCharacters("\n");
        this.output.writeComment(this.path.toString());
        this.output.writeCharacters("\n");
        super.handleEndElement(uri, localName, qName);
    }

    public static void main(String[] args) throws Throwable {
        String id = "/local/colonet/colonet/combined/download/pubmed/PMC/files/Cancer_Inform-7--2730178.nxml";
        PrintStream out = System.out;
        XmlPrinter printer = new XmlPrinter(out);
        XmlReader xmlReader = new XmlReader(printer);
        StringBuilder text = StringBuilders.getContent(id);
        StringBuilders.removePrefixUntil(text, "<article");
        xmlReader.handleText(text);
    }

    @Override
    public AdvancedXmlHandler.Event getEvent() {
        return AdvancedXmlHandler.Event.Dummy;
    }
}

