/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.misc.StringBuilders;
import de.berlin.hu.wbi.common.xml.AdvancedXmlHandler;
import de.berlin.hu.wbi.common.xml.XmlReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;

public class XmlAnalyser
extends AdvancedXmlHandler<AdvancedXmlHandler.Event> {
    Map<String, String> paths = new HashMap<String, String>();
    private String source;

    public XmlAnalyser() {
        super(EnumSet.noneOf(AdvancedXmlHandler.Event.class));
    }

    public static void main(String[] args) throws Throwable {
        File file = new File("/local/colonet/colonet/combined/download/pubmed/PMC/files/");
        Object[] files = file.listFiles();
        Arrays.sort(files);
        SAXParserFactory.newInstance().setNamespaceAware(true);
        XmlAnalyser xmlAnalyser = new XmlAnalyser();
        XmlReader reader = new XmlReader(xmlAnalyser);
        ArrayList<File> notWorking = new ArrayList<File>();
        int count = 0;
        ArrayDeque<Object> list = new ArrayDeque<Object>();
        for (Object file2 : files) {
            list.add(file2);
        }
        StringBuilder content = new StringBuilder();
        while (list.size() > 0) {
            File file1 = (File)list.removeFirst();
            String canonicalPath = file1.getCanonicalPath();
            if (canonicalPath.endsWith(".nxml")) {
                ++count;
                FileReader read = new FileReader(canonicalPath);
                StringBuilders.appendReaderContent(content, read);
                ((Reader)read).close();
                StringBuilders.removePrefixUntil(content, "<article");
                try {
                    xmlAnalyser.setSource(canonicalPath);
                    reader.handleText(content);
                }
                catch (Exception e) {
                    notWorking.add(file1);
                }
                if (count % 1000 == 0) {
                    System.out.println(count);
                }
            }
            content.setLength(0);
        }
        PrintStream a = new PrintStream("/vol/fob-vol5/mi06/arzt/Desktop/testcase/paths2.txt");
        xmlAnalyser.printPahts(a);
        PrintStream notWorkingStream = new PrintStream("/vol/fob-vol5/mi06/arzt/Desktop/testcase/not-working.txt");
        for (File file2 : notWorking) {
            notWorkingStream.println(file2);
        }
    }

    private void setSource(String canonicalPath) {
        this.source = canonicalPath;
    }

    public void printPahts(Appendable a) throws IOException {
        ArrayList<String> list = new ArrayList<String>(this.paths.keySet());
        Collections.sort(list);
        for (String path : list) {
            a.append(path);
            a.append("\t\t\t\t");
            a.append(this.paths.get(path));
            a.append('\n');
        }
    }

    @Override
    public void handleStartElement(String uri, String localName, String qName, Attributes attributes) throws Throwable {
        super.handleStartElement(uri, localName, qName, attributes);
        this.paths.put(this.path.toString(), this.source);
    }

    @Override
    public AdvancedXmlHandler.Event getEvent() {
        return AdvancedXmlHandler.Event.Dummy;
    }
}

