/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.io.IO;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XPathKit {
    private static XPath xPath;
    private static Map<String, XPathExpression> expressions;

    public static XPathExpression compile(String expression) throws XPathExpressionException {
        XPathExpression xPathExpression = expressions.get(expression);
        if (xPathExpression == null) {
            xPathExpression = XPathKit.getXPath().compile(expression);
            expressions.put(expression, xPathExpression);
        }
        return xPathExpression;
    }

    public static XPath getXPath() {
        if (xPath == null) {
            xPath = XPathFactory.newInstance().newXPath();
        }
        return xPath;
    }

    public static Document asDocument(InputStream openStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        Document doc = domFactory.newDocumentBuilder().parse(openStream);
        return doc;
    }

    public static Document asDocument(String locator) throws SAXException, IOException, ParserConfigurationException {
        return XPathKit.asDocument(IO.open(locator));
    }

    public static NodeList evaluate(InputStream input, String expression) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Document document = XPathKit.asDocument(input);
        XPathExpression xpath = XPathKit.compile(expression);
        NodeList result = XPathKit.evaluate((Object)document, xpath);
        return result;
    }

    public static NodeList evaluate(String locator, String expression) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        InputStream input = IO.open(locator);
        return XPathKit.evaluate(input, expression);
    }

    public static NodeList evaluate(InputStream input, XPathExpression expression) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Document document = XPathKit.asDocument(input);
        NodeList result = XPathKit.evaluate((Object)document, expression);
        return result;
    }

    public static NodeList evaluate(Object source, XPathExpression expression) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        NodeList result = (NodeList)expression.evaluate(source, XPathConstants.NODESET);
        return result;
    }

    @Deprecated
    public static NodeList evaluate(Object source, String expression) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        XPathExpression xPathExpression = XPathKit.compile(expression);
        NodeList result = XPathKit.evaluate(source, xPathExpression);
        return result;
    }

    public static Boolean evaluateAsBoolean(Object source, XPathExpression expression) throws XPathExpressionException {
        return (Boolean)expression.evaluate(source, XPathConstants.BOOLEAN);
    }

    public static Boolean evaluateAsBoolean(Object source, String expression) throws XPathExpressionException {
        return (Boolean)XPathKit.compile(expression).evaluate(source, XPathConstants.BOOLEAN);
    }

    public static Node evaluateAsNode(Object source, XPathExpression expression) throws XPathExpressionException {
        return (Node)expression.evaluate(source, XPathConstants.NODE);
    }

    public static Node evaluateAsNode(Object source, String expression) throws XPathExpressionException {
        return (Node)XPathKit.compile(expression).evaluate(source, XPathConstants.NODE);
    }

    public static NodeList evaluateAsNodeSet(Object source, XPathExpression expression) throws XPathExpressionException {
        return (NodeList)expression.evaluate(source, XPathConstants.NODESET);
    }

    public static NodeList evaluateAsNodeSet(Object source, String expression) throws XPathExpressionException {
        return (NodeList)XPathKit.compile(expression).evaluate(source, XPathConstants.NODESET);
    }

    public static Double evaluateAsNumber(Object source, XPathExpression expression) throws XPathExpressionException {
        return (Double)expression.evaluate(source, XPathConstants.NUMBER);
    }

    public static Double evaluateAsNumber(Object source, String expression) throws XPathExpressionException {
        return (Double)XPathKit.compile(expression).evaluate(source, XPathConstants.NUMBER);
    }

    public static String evaluateAsString(Object source, XPathExpression expression) throws XPathExpressionException {
        return (String)expression.evaluate(source, XPathConstants.STRING);
    }

    public static String evaluateAsString(Object source, String expression) throws XPathExpressionException {
        return (String)XPathKit.compile(expression).evaluate(source, XPathConstants.STRING);
    }

    public static CharSequence deepToString(Node node, StringBuilder builder) {
        if (node != null && node.getLocalName() != null) {
            Node parentNode = node.getParentNode();
            XPathKit.deepToString(parentNode, builder);
            builder.append('/').append(node.getLocalName());
        }
        return builder;
    }

    static {
        expressions = new HashMap<String, XPathExpression>(10);
    }
}

