/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.xml.Context;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;

public class NodeBasedClass<N, L> {
    private N base;
    protected Context<N, L> context;

    public NodeBasedClass(Context<N, L> context, N base) {
        this.inherit(context, base);
    }

    public NodeBasedClass() {
    }

    public void inherit(Context<N, L> context, N base) {
        this.context = context;
        this.setNodeBase(base);
    }

    public void setNodeBase(N node) {
        this.base = node;
    }

    protected String evaluateAsString(String expression) {
        return (String)this.evaluate(expression, XPathConstants.STRING);
    }

    protected N evaluateAsNode(String expression) {
        return (N)this.evaluate(expression, XPathConstants.NODE);
    }

    protected L evaluateAsNodeSet(String expression) {
        return (L)this.evaluate(expression, XPathConstants.NODESET);
    }

    protected Double evaluateAsNumber(String expression) {
        return (Double)this.evaluate(expression, XPathConstants.NUMBER);
    }

    protected Boolean evaluateAsBoolean(String expression) {
        return (Boolean)this.evaluate(expression, XPathConstants.BOOLEAN);
    }

    protected void instanciateNodeList(Class<?> clazz, L list, Object[] array) {
        int size = this.context.size(list);
        ArrayList<Object> output = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object instance = this.instanciateNodeBasedClass(clazz, this.context.get(i, list));
            output.add(instance);
        }
        output.toArray(array);
    }

    protected Object evaluate(String expression, QName type) {
        try {
            XPathExpression exp = this.context.getExpression(expression);
            Object result = exp.evaluate(this.base, type);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object instanciateNodeBasedClass(Class<?> clazz, N node) {
        NodeBasedClass instance;
        try {
            instance = (NodeBasedClass)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        instance.inherit(this.context, node);
        return instance;
    }

    public N getNodeBase() {
        return this.base;
    }

    public CharSequence rekursiveToString(N node, StringBuilder builder) {
        if (node != null && this.context.getName(node) != null) {
            this.rekursiveToString(this.context.getParent(node), builder);
            builder.append(this.context.getName(node));
            builder.append('/');
        }
        return builder;
    }

    public String toString(N node) {
        return ((Object)this.rekursiveToString(node, new StringBuilder())).toString();
    }
}

