/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.misc.StringBuilders;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EventBasedHandler
extends DefaultHandler {
    protected final StringBuilder path = new StringBuilder();
    protected final Deque<Attributes> attributesDeque = new ArrayDeque<Attributes>();
    protected final StringBuilder buffer = new StringBuilder();
    protected final Deque<Boolean> enabled = new ArrayDeque<Boolean>();
    protected Appendable debug = null;

    public EventBasedHandler() {
        this.enabled.addLast(false);
    }

    public void setDebugOutput(Appendable a) {
        this.debug = a;
    }

    public final boolean pathEquals(String p) {
        return StringBuilders.equals(this.path, p);
    }

    public final boolean pathEndsWith(String string) {
        return StringBuilders.endsWith(this.path, string);
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.isEnabled().booleanValue()) {
                this.buffer.append(ch, start, length);
            }
            if (this.debug != null) {
                this.debug.append(this.getDebugMessage());
            }
        }
        catch (Throwable e) {
            throw new SAXException(new Exception(e));
        }
    }

    public void startEvent() {
    }

    public void endEvent() {
    }

    public void performEvent() throws Throwable {
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.path.append('/').append(localName);
        this.attributesDeque.add(attributes);
        try {
            this.startEvent();
            this.performEvent();
        }
        catch (Throwable e) {
            throw new SAXException(new Exception(e));
        }
    }

    private void truncatePath(String localName) {
        int newLength = this.path.length() - localName.length() - 1;
        this.path.setLength(newLength);
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.performEvent();
            this.endEvent();
        }
        catch (Throwable e) {
            throw new SAXException(new Exception(e));
        }
        this.truncatePath(localName);
    }

    public final boolean attributeEquals(String key, String input) {
        String value = this.attributesDeque.getLast().getValue(key);
        boolean equals = input.equals(value);
        return equals;
    }

    public final void printState(Appendable a) throws IOException {
        a.append(this.path);
        Attributes attributes = this.attributesDeque.getLast();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String key = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                a.append('|').append(key).append('=').append(value);
            }
            a.append('\n');
        }
    }

    public CharSequence getDebugMessage() {
        return "";
    }

    public final Boolean isEnabled() {
        return this.enabled.getLast();
    }

    public void clearBuffer() {
        this.buffer.setLength(0);
    }
}

