/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.misc.CharSequences;
import de.berlin.hu.wbi.common.misc.ListMap;
import de.berlin.hu.wbi.common.xml.DefaultXmlHandler;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Map;
import org.xml.sax.Attributes;

public abstract class AdvancedXmlHandler<E extends Enum<E>>
extends DefaultXmlHandler {
    protected final Deque<String> openElements = new ArrayDeque<String>();
    protected final StringBuilder path = new StringBuilder();
    protected final Deque<Attributes> attributesDeque = new ArrayDeque<Attributes>();
    private final Deque<Boolean> enabled = new ArrayDeque<Boolean>();
    protected final Deque<E> eventDeque = new ArrayDeque();
    private EnumSet<E> activeEvents;
    protected Appendable debug = null;
    protected Map<String, E> eventMap = new ListMap<String, E>();

    public AdvancedXmlHandler(EnumSet<E> active) {
        this.enabled.addLast(false);
        this.activeEvents = active;
    }

    public void setDebugOutput(Appendable a) {
        this.debug = a;
    }

    public final boolean isPathSuffix(String string) {
        return CharSequences.endsWith(this.path, string);
    }

    public abstract E getEvent() throws Throwable;

    @Override
    public void handleStartElement(String uri, String localName, String qName, Attributes attributes) throws Throwable {
        this.enabled.addLast(this.enabled.getLast());
        this.path.append('/').append(localName);
        this.openElements.addLast(localName);
        this.attributesDeque.add(attributes);
        E object = this.getEvent();
        this.eventDeque.addLast(object);
        this.activeEvents.add(object);
        if (this.debug != null && this.isEnabled().booleanValue()) {
            this.printState(this.debug);
        }
        this.startEvent();
    }

    protected void startEvent() throws Throwable {
    }

    private void truncatePath(String localName) {
        int newLength = this.path.length() - localName.length() - 1;
        this.path.setLength(newLength);
    }

    @Override
    public void handleEndElement(String uri, String localName, String qName) throws Throwable {
        if (this.debug == null || this.isEnabled().booleanValue()) {
            // empty if block
        }
        this.endEvent();
        this.truncatePath(localName);
        this.openElements.removeLast();
        Enum last = (Enum)this.eventDeque.removeLast();
        this.activeEvents.remove(last);
        this.enabled.removeLast();
    }

    protected void endEvent() throws Throwable {
    }

    public final boolean attributeEquals(String key, String input) {
        String value = this.attributesDeque.getLast().getValue(key);
        boolean equals = input.equals(value);
        return equals;
    }

    public final void printState(Appendable a) throws IOException {
        a.append(this.path);
        Attributes attributes = this.attributesDeque.getLast();
        if (attributes != null) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                String key = attributes.getLocalName(i);
                String value = attributes.getValue(i);
                a.append('|').append(key).append('=').append(value);
            }
            a.append('\n');
        }
    }

    public CharSequence getDebugMessage() {
        return this.eventDeque + "\n" + "\n";
    }

    public final Boolean isEnabled() {
        return this.enabled.getLast();
    }

    public void reset() {
        this.activeEvents.clear();
        this.openElements.clear();
        this.path.setLength(0);
        this.attributesDeque.clear();
        this.enabled.clear();
        this.enabled.addLast(false);
    }

    public void enable() {
        this.enabled.removeLast();
        this.enabled.addLast(true);
    }

    public void disable() {
        this.enabled.removeLast();
        this.enabled.addLast(false);
    }

    public boolean isActive(E event) {
        return this.activeEvents.contains(event);
    }

    public E getEventByPath(E def) {
        Object event = def;
        for (String suffix : this.eventMap.keySet()) {
            if (!this.isPathSuffix(suffix)) continue;
            event = (Enum)this.eventMap.get(suffix);
            break;
        }
        return event;
    }

    public static enum Event {
        Dummy;

    }
}

