/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.xml;

import de.berlin.hu.wbi.common.layer.XmlHandler;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AdvancedHandler
extends DefaultHandler {
    protected Deque<String> openElements = new ArrayDeque<String>();
    private StringBuilder characters = new StringBuilder();
    private XmlHandler layer;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.openElements.addLast(localName);
        try {
            if (this.charactersAreAvailable()) {
                this.layer.handleCharacters(this.characters);
            }
            this.layer.handleStartElement(this.openElements, atts);
        }
        catch (Throwable e) {
            throw new SAXException(new Exception(e));
        }
        this.characters.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    public boolean charactersAreAvailable() {
        return this.characters.length() > 0;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.charactersAreAvailable()) {
                this.layer.handleCharacters(this.characters);
            }
            this.layer.handleEndElement(this.openElements);
        }
        catch (Throwable e) {
            throw new SAXException(new Exception(e));
        }
        this.characters.setLength(0);
        this.openElements.removeLast();
    }

    public void connect(XmlHandler layer) {
        this.layer = layer;
    }
}

