/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie.old;

import de.berlin.hu.wbi.common.trie.old.AcceptingNode;
import de.berlin.hu.wbi.common.trie.old.Node;
import java.util.ArrayList;
import java.util.Collection;

public class Trie
extends Node {
    private static final long serialVersionUID = -1606552866411058418L;
    private int nodeCount = 0;
    private int size = 0;
    Collection<Node> nodes = new ArrayList<Node>(1000);

    public void add(byte[] word) {
        this.add(word, 0, word.length);
    }

    public boolean contains(byte[] word) {
        Node node = this;
        for (byte b : word) {
            node = ((Node)node).traverse(b);
        }
        return node instanceof AcceptingNode;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public String toStringComplete() {
        StringBuilder b = new StringBuilder();
        this.toStringRecursive(b, this);
        return b.toString();
    }

    @Override
    public String toString() {
        return "Trie [NodeCount: " + String.valueOf(this.getNodeCount()) + "]";
    }

    private void toStringRecursive(StringBuilder b, Node node) {
        if (node instanceof AcceptingNode) {
            b.append(new String(node.getBytes()));
            b.append('\n');
        }
        for (int j = 0; j < 256; ++j) {
            Node next = node.next[j];
            if (next == null) continue;
            this.toStringRecursive(b, next);
        }
    }

    public void addObjects(Object ... objects) {
        for (Object object : objects) {
            this.addObject(object);
        }
    }

    public void addObject(Object o) {
        String string = o.toString();
        byte[] word = string.getBytes();
        this.add(word);
    }

    public void add(byte[] word, int start, int end) {
        Node parent = this;
        int last = Math.min(word.length, end);
        for (int pos = start; pos < last; ++pos) {
            byte value = word[pos];
            Node next = parent.match(value);
            if (next == null) {
                next = new Node(value, parent);
                this.nodes.add(next);
                parent.setNext(value, next);
                ++this.nodeCount;
            }
            if (pos == word.length - 1) {
                next = new AcceptingNode(next);
                parent.setNext(value, next);
            }
            parent = next;
        }
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }
}

