/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie.old;

import de.berlin.hu.wbi.common.io.IO;
import de.berlin.hu.wbi.common.trie.old.AcceptingNode;
import de.berlin.hu.wbi.common.trie.old.Trie;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

class Node
implements Serializable {
    private static final int _128 = 128;
    private static final long serialVersionUID = 6817180064778749585L;
    private int depth;
    protected byte value;
    protected Node[] next = new Node[256];
    protected Node fail;
    protected Node parent;
    protected AcceptingNode out;

    protected Node() {
        this.value = 0;
        this.parent = null;
        this.depth = 0;
        this.fail = this;
    }

    public Node(byte value, Node par) {
        if (par == null) {
            throw new NullPointerException("Parent node must not be null.");
        }
        this.value = value;
        this.parent = par;
        this.depth = par.depth + 1;
        while (this.fail == null) {
            this.fail = par.fail.match(value);
            par = par.fail;
            if (this.fail != null || par != par.fail) continue;
            this.fail = par;
        }
        this.out = this.fail instanceof AcceptingNode ? (AcceptingNode)this.fail : this.fail.out;
    }

    public byte getValue() {
        return this.value;
    }

    public Node match(byte b) {
        return this.next[b + 128];
    }

    public void setNext(byte b, Node n) {
        this.next[b + 128] = n;
    }

    public void setFail(Node n) {
        this.fail = n;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        byte[] bytes = this.getBytes();
        b.append(new String(bytes));
        b.append(" [");
        for (Node n : this.next) {
            if (n == null) continue;
            b.append(n.value + 128);
            b.append(",");
        }
        b.append(']');
        return b.toString();
    }

    public byte[] getBytes() {
        byte[] array = new byte[this.depth];
        this.fill(array);
        return array;
    }

    public int getBytes(byte[] b) {
        this.fill(b);
        return this.depth;
    }

    private void fill(byte[] array) {
        if (this.depth > 0) {
            array[this.depth - 1] = this.value;
            this.parent.fill(array);
        }
    }

    public Node traverse(byte b) {
        Node result = this.match(b);
        if (result == null) {
            result = this instanceof Trie ? this : this.fail.traverse(b);
        }
        return result;
    }

    public Node traverse(Object o) {
        String string = o.toString();
        byte[] bytes = string.getBytes();
        Node node = this;
        for (byte b : bytes) {
            node = node.traverse(b);
        }
        return node;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    public static void main(String[] args) throws IOException {
        Trie trie = new Trie();
        byte[] a = new byte[100];
        Random r = new Random();
        int c = 1000;
        while (c-- > 0) {
            r.nextBytes(a);
            trie.add(a);
            System.out.println(trie.getSize() + ": " + trie.getNodeCount());
        }
        IO.serialize(trie, "test.bin");
    }
}

