/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie.legacy;

import de.berlin.hu.wbi.common.layer.TextHandler;
import de.berlin.hu.wbi.common.layer.TokenHandler;
import de.berlin.hu.wbi.common.trie.Trie;
import java.util.regex.MatchResult;

public class TrieMatcherOld
implements MatchResult,
TextHandler {
    private Trie trie;
    private CharSequence text;
    private String match;
    private int index = 0;
    int node = 0;
    int outputLink = 0;
    private TokenHandler layer;

    public TrieMatcherOld(Trie trie) {
        this.trie = trie;
    }

    public void reset(CharSequence text) {
        this.text = text;
        this.index = 0;
        this.node = 0;
    }

    public static byte[] toCharToByteArray(int c) {
        String string = String.valueOf((char)c);
        byte[] bytes = string.getBytes();
        return bytes;
    }

    public boolean find(int i) {
        this.reset(this.text);
        this.index = i;
        return this.find();
    }

    public boolean isAccepting(int node) {
        if (node < 0) {
            return false;
        }
        this.outputLink = this.trie.getNode(node).getOutputLink();
        if (this.trie.getNode(node).isAccepting()) {
            this.match = this.trie.toString(node);
            return true;
        }
        this.match = null;
        return false;
    }

    public boolean find() {
        if (this.isAccepting(this.outputLink)) {
            return true;
        }
        if (this.index == this.text.length()) {
            return false;
        }
        while (this.index < this.text.length()) {
            byte[] array;
            char c = this.text.charAt(this.index);
            for (byte b : array = TrieMatcherOld.toCharToByteArray(c)) {
                this.node = this.trie.traverse(this.node, b);
            }
            ++this.index;
            if (!this.isAccepting(this.node) && !this.isAccepting(this.outputLink)) continue;
            return true;
        }
        return this.isAccepting(this.node);
    }

    @Override
    public int start() {
        if (this.match != null) {
            return this.index - this.match.length();
        }
        throw new IllegalStateException("No match found.");
    }

    @Override
    public int start(int group) {
        return this.start();
    }

    @Override
    public int end() {
        if (this.match != null) {
            return this.index;
        }
        throw new IllegalStateException("No match found.");
    }

    @Override
    public int end(int group) {
        return this.end();
    }

    @Override
    public String group() {
        if (this.match != null) {
            return this.match;
        }
        throw new IllegalStateException("No match found.");
    }

    @Override
    public String group(int group) {
        return this.group();
    }

    @Override
    public int groupCount() {
        return 1;
    }

    public String toString() {
        return ((Object)this.text.subSequence(0, this.index)).toString();
    }

    @Override
    public void handleText(CharSequence text) {
        this.reset(text);
        while (this.find()) {
            this.layer.handleToken(text, this.start(), this.end());
        }
    }

    public void connect(TokenHandler layer) {
        this.layer = layer;
    }
}

