/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie;

import de.berlin.hu.wbi.common.trie.AbstractTrie;
import java.io.IOException;
import java.util.ArrayDeque;

public class TrieTool {
    public void getGraph(AbstractTrie trie, Appendable out) throws IOException {
        ArrayDeque<Integer> deque = new ArrayDeque<Integer>();
        deque.add(0);
        while (!deque.isEmpty()) {
            int first = (Integer)deque.pollFirst();
            for (int i : trie.getChildren(first)) {
                int outputLink;
                char c = (char)trie.getValue(i);
                if (c == '\n' || Character.isWhitespace(c)) {
                    c = '?';
                }
                out.append(first + " " + c + " " + i);
                deque.addLast(i);
                int failureLink = trie.getFailureLink(i);
                if (failureLink > 0) {
                    // empty if block
                }
                if ((outputLink = trie.getFailureLink(i)) <= 0) continue;
            }
        }
    }
}

