/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie;

import de.berlin.hu.wbi.common.layer.TextHandler;
import de.berlin.hu.wbi.common.layer.TokenHandler;
import de.berlin.hu.wbi.common.trie.MatcherTrie;

public class TrieMatcher
implements TextHandler {
    private MatcherTrie t;
    private TokenHandler layer;

    public TrieMatcher(MatcherTrie trie) {
        this.t = trie;
    }

    @Override
    public void handleText(CharSequence text) {
        int node = 0;
        int start = 0;
        for (int i = 0; i < text.length(); ++i) {
            char charAt = text.charAt(i);
            if ((node = this.t.traverseChar(node, charAt)) == 0) {
                start = i;
            }
            if (this.t.isAccepting(node)) {
                this.layer.handleToken(text, start, i);
            }
            this.handleOutputLinks(text, node, i);
        }
    }

    private void handleOutputLinks(CharSequence text, int node, int i) {
        if (node > 0) {
            int outputLink = this.t.getOutputLink(node);
            if (outputLink > 0) {
                int depth = this.t.getDepth(node);
                this.layer.handleToken(text, i - depth, i);
            }
            this.handleOutputLinks(text, outputLink, i);
        }
    }

    public void connect(TokenHandler layer) {
        this.layer = layer;
    }
}

