/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie;

import de.berlin.hu.wbi.common.trie.Trie;
import de.berlin.hu.wbi.common.trie.impl.TrieFactory;
import de.berlin.hu.wbi.common.trie.legacy.TrieMatcherOld;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Random;
import java.util.Scanner;

public class TrieExample {
    public static void main(String[] args) throws FileNotFoundException {
        Scanner s = new Scanner(new File("/home/realdocx/.dict/de.dict"));
        Trie trie = TrieFactory.newTrie();
        while (s.hasNext()) {
            String next = s.next();
            System.out.println(next);
            trie.addObject(next);
        }
        trie.computeLinks();
        trie.getGraph(new PrintStream("test.txt"));
    }

    public static void example3() {
        Trie trie = TrieFactory.newTrie();
        byte[] a = new byte[10000];
        Random r = new Random();
        while (true) {
            r.nextBytes(a);
            trie.add(a);
            System.out.println(trie.getSize() + ": " + trie.getNodeCount());
        }
    }

    public static void example2() throws FileNotFoundException {
        Trie trie = TrieFactory.newTrie();
        String text = "dies ist ein test";
        trie.addObjects("die", "dies", "ist", "i", "t", "test");
        System.out.println(trie);
        trie.computeLinks();
        TrieMatcherOld matcher = new TrieMatcherOld(trie);
        matcher.reset(text);
        while (matcher.find()) {
            System.out.format("%s@%s-%s\n", matcher.group(), matcher.start(), matcher.end());
        }
    }

    public static void example1() throws FileNotFoundException {
        String text = "Wenn Sie den Newsletter in Zukunft nicht mehr haben m\u00f6chten, passen Sie einfach Ihre Benachrichtigungseinstellungen in Mein eBay an.\nWir werten Ihre Reaktion auf diesen Newsletter pseudonymisiert auf der Basis Ihres Mitgliedsnamens aus. So k\u00f6nnen wir Ihnen in Zukunft st\u00e4rker auf Ihre Interessen zugeschnittene Newsletter zusenden. Wenn Sie dies nicht w\u00fcnschen, bestellen Sie den Newsletter bitte wie oben beschrieben ab.";
        String a = "n Sie den News";
        String b = "ch Ihre Benach";
        String c = "y an.\nWir";
        String d = "ymisiert auf der Basis I";
        String e = ". So k\u00f6nnen";
        String f = "en zugeschnittene Newsletter zusenden. W";
        String g = "n Newsletter bi";
        String h = "en ab.";
        Trie trie = TrieFactory.newTrie();
        trie.addObjects(b, c, d, e, f, g, h, a, "Wenn");
        trie.computeLinks();
        trie.getGraph(new PrintStream("test.txt"));
        System.out.println("Count: " + trie.getNodeCount());
        TrieMatcherOld matcher = new TrieMatcherOld(trie);
        matcher.reset(text);
        while (matcher.find()) {
            System.out.format("%s@%s-%s\n", matcher.group(), matcher.start(), matcher.end());
        }
    }
}

