/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie;

import de.berlin.hu.wbi.common.io.IO;
import de.berlin.hu.wbi.common.trie.impl.TrieFactory;
import de.berlin.hu.wbi.common.trie.legacy.Node;
import de.berlin.hu.wbi.common.trie.legacy.NodeFactory;
import de.berlin.hu.wbi.common.trie.legacy.TrieMatcherOld;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;

public class Trie
implements Serializable {
    private static final long serialVersionUID = -1606552866411058418L;
    private int nodeCount = 1;
    private int size = 0;
    private transient StringBuilder stringBuilder = new StringBuilder();
    private int longestLength = 0;
    private transient NodeFactory factory;
    protected Node[] nodes;
    protected byte[] values;
    private byte[] buffer;

    public Trie(NodeFactory factory) {
        Node root;
        this.factory = factory;
        this.nodes = new Node[1024];
        this.values = new byte[1024];
        this.nodes[0] = root = factory.newNode();
    }

    public void finish() {
        this.nodes = Arrays.copyOf(this.nodes, this.nodeCount);
        this.values = Arrays.copyOf(this.values, this.nodeCount);
    }

    public void add(byte[] word) {
        this.add(word, 0, word.length);
    }

    public int getLongestLength() {
        return this.longestLength;
    }

    public void computeLinks() {
        ArrayDeque<Integer> nodes = new ArrayDeque<Integer>();
        nodes.add(0);
        while (!nodes.isEmpty()) {
            int first = (Integer)nodes.pollFirst();
            Node node = this.getNode(first);
            for (int i = -128; i <= 127; ++i) {
                int next = node.getNext(i);
                if (next <= -1) continue;
                nodes.addLast(next);
            }
            if (first == 0) continue;
            this.computeLinks(first);
        }
    }

    public boolean contains(byte[] word) {
        int node = 0;
        for (byte b : word) {
            node = this.traverse(node, b);
        }
        return this.getNode(node).isAccepting();
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public String toStringComplete() {
        this.stringBuilder.setLength(0);
        this.toStringRecursive(0);
        return this.stringBuilder.toString();
    }

    public String toString() {
        int offset = 1;
        return new String(this.values, offset, this.values.length - offset);
    }

    public void computeLinks(int node) {
        int failureLink = 0;
        Node nodeObject = this.getNode(node);
        int parent = nodeObject.getParent();
        int value = this.getValue(node);
        while (failureLink == 0 && parent > 0) {
            Node parentNodeObject = this.getNode(parent);
            int parentFailureLink = parentNodeObject.getFailureLink();
            failureLink = this.getNode(parentFailureLink).getNext(value);
            failureLink = Math.max(0, failureLink);
            parent = parentNodeObject.getParent();
        }
        nodeObject.setFailureLink(failureLink);
        if (this.getNode(failureLink).isAccepting()) {
            nodeObject.setOutputLink(failureLink);
        } else {
            int outputLink = this.getNode(failureLink).getOutputLink();
            if (outputLink > -1) {
                nodeObject.setOutputLink(outputLink);
            }
        }
    }

    public int getValue(int node) {
        return this.values[node];
    }

    public void setValue(int node, int value) {
        this.values[node] = (byte)value;
    }

    public int fillBytes(int node) {
        if (node == 0) {
            this.initBuffer();
            return 0;
        }
        int parent = this.getNode(node).getParent();
        int i = this.fillBytes(parent);
        this.buffer[i] = (byte)this.getValue(node);
        return i + 1;
    }

    public byte[] getBytes(int node) {
        int i = this.fillBytes(node);
        byte[] output = Arrays.copyOf(this.buffer, i);
        return output;
    }

    public String getString(int node) {
        int i = this.fillBytes(node);
        String string = new String(this.buffer, 0, i);
        return string;
    }

    private byte[] initBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.longestLength];
        }
        return this.buffer;
    }

    public Node getNode(int i) {
        if (i < 0) {
            return null;
        }
        return this.nodes[i];
    }

    private void toStringRecursive(int node) {
        if (this.getNode(node).isAccepting()) {
            int length = this.fillBytes(node);
            String str = new String(this.initBuffer(), 0, length);
            this.stringBuilder.append(str);
            this.stringBuilder.append('\n');
        } else {
            for (int j = -128; j <= 127; ++j) {
                int child = this.getNode(node).getNext(j);
                if (child <= -1) continue;
                this.toStringRecursive(child);
            }
        }
    }

    public void addObjects(Object ... objects) {
        for (Object object : objects) {
            this.addObject(object);
        }
    }

    public void addObject(Object o) {
        String string = o.toString();
        byte[] word = string.getBytes();
        this.add(word);
    }

    public void add(byte[] bytes, int start, int end) {
        this.longestLength = Math.max(this.longestLength, end - start);
        int node = 0;
        end = Math.min(bytes.length, end);
        for (int pos = start; pos < end; ++pos) {
            byte value = bytes[pos];
            Node nodeObject = this.getNode(node);
            int next = nodeObject.getNext(value);
            if (next < 0) {
                Node newNode = this.factory.newNode();
                next = this.addNode(newNode, node, value);
            }
            node = next;
        }
        this.toAcceptingNode(node);
        ++this.size;
    }

    private void toAcceptingNode(int node) {
        Node newAcceptingNode;
        this.nodes[node] = newAcceptingNode = this.factory.newAcceptingNode(this.getNode(node));
    }

    public int addNode(Node node, int parent, int value) {
        if (this.nodeCount == this.nodes.length) {
            this.allocate();
        }
        int i = this.nodeCount++;
        this.setValue(i, value);
        this.nodes[i] = node;
        node.setParent(parent);
        this.getNode(parent).setNext(value, i);
        return i;
    }

    private void allocate() {
        int length = this.nodes.length << 1;
        this.nodes = Arrays.copyOf(this.nodes, length);
        this.values = Arrays.copyOf(this.values, length);
    }

    public int getSize() {
        return this.size;
    }

    public int traverse(int node, int value) {
        Node nodeObject = this.getNode(node);
        int result = nodeObject.getNext(value);
        if (result < 0) {
            if (node == 0) {
                result = node;
            } else {
                int failureLink = nodeObject.getFailureLink();
                result = this.traverse(failureLink, value);
            }
        }
        return result;
    }

    public void getGraph(PrintStream out) {
        ArrayDeque<Integer> deque = new ArrayDeque<Integer>();
        deque.add(0);
        while (!deque.isEmpty()) {
            int first = (Integer)deque.pollFirst();
            for (int i = -128; i < 127; ++i) {
                int outputLink;
                int next = this.getNode(first).getNext(i);
                if (next <= -1) continue;
                char c = (char)this.getValue(next);
                if (c == '\n' || Character.isWhitespace(c)) {
                    c = '?';
                }
                out.println(first + " " + c + " " + next);
                deque.addLast(next);
                int failureLink = this.getNode(next).getFailureLink();
                if (failureLink > 0) {
                    // empty if block
                }
                if ((outputLink = this.getNode(next).getOutputLink()) <= 0) continue;
            }
        }
        out.close();
    }

    public String toString(int node) {
        int i = this.fillBytes(node);
        String string = new String(this.buffer, 0, i);
        return string;
    }

    public static void main(String[] args) throws IOException {
        Trie t = TrieFactory.newTrie();
        t.add("du".getBytes());
        t.add("Hallo".getBytes());
        t.add("hMensc".getBytes());
        t.add("Men".getBytes());
        t.add("dort".getBytes());
        t.computeLinks();
        System.out.println(t.toString());
        TrieMatcherOld m = new TrieMatcherOld(t);
        m.reset("sfhahMensch");
        while (m.find()) {
            System.out.println(m.group() + ":\t" + m.start() + "-" + m.end());
        }
    }

    public void serialize(String file) throws IOException {
        boolean compress = false;
        IO.serialize(this, file, compress);
    }

    public static Trie deserialize(String file) throws FileNotFoundException, ClassNotFoundException, IOException {
        boolean decompress = false;
        return (Trie)IO.deserialize(file, decompress);
    }
}

