/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie;

import de.berlin.hu.wbi.common.map.ArrayCharMap;
import de.berlin.hu.wbi.common.map.HashCharMap;
import de.berlin.hu.wbi.common.map.PrimitiveMap;
import de.berlin.hu.wbi.common.trie.AbstractTrie;
import java.io.IOException;
import java.util.Arrays;

public class CharTrie
extends AbstractTrie {
    private static final long serialVersionUID = -83007138315258241L;
    private char[] values;
    private StringBuilder content = new StringBuilder();

    public CharTrie() {
        this.values = new char[this.bufferSize];
        this.values[0] = 63;
    }

    @Override
    public int getValue(int node) {
        return this.values[node];
    }

    @Override
    void setValue(int node, int value) {
        char c = (char)value;
        this.content.append(c);
        this.values[node] = c;
    }

    @Override
    public void addString(Object o) {
        CharSequence sequence = null;
        if (!(o instanceof CharSequence)) {
            sequence = o.toString();
        }
        sequence = (CharSequence)o;
        int length = sequence.length();
        this.add(sequence, 0, length);
    }

    void add(CharSequence s, int offset, int length) {
        int node = 0;
        for (int i = 0; i < length; ++i) {
            char value = s.charAt(i + offset);
            node = this.add(node, value);
        }
        this.end(node);
    }

    void add(char[] s, int offset, int length) {
        int node = 0;
        for (char c : s) {
            node = this.add(node, c);
        }
        this.end(node);
    }

    @Override
    PrimitiveMap newMap() {
        return new HashCharMap();
    }

    @Override
    protected void allocate(int length) {
        super.allocate(length);
        this.values = Arrays.copyOf(this.values, length);
    }

    @Override
    public void printNode(int index, Appendable out) throws IOException {
        int parent = this.getParent(index);
        if (parent > 0) {
            this.printNode(parent, out);
        }
        char value = (char)this.getValue(index);
        out.append(value);
    }

    @Override
    public void finish() {
        super.finish();
        for (int i = 0; i < this.maps.length; ++i) {
            PrimitiveMap map = this.maps[i];
            if (map == null) continue;
            int size = map.getSize();
            if (size == 0) {
                System.out.println("Null!");
            }
            if (map.getSize() == 1) {
                this.maps[i] = null;
                continue;
            }
            ArrayCharMap arrayCharMap = new ArrayCharMap();
            arrayCharMap.addAll(map);
            this.maps[i] = arrayCharMap;
        }
    }

    @Override
    public boolean containsString(Object string) {
        CharSequence sequence = null;
        sequence = string instanceof CharSequence ? (CharSequence)string : string.toString();
        int node = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            char value = sequence.charAt(i);
            node = this.traverse(node, value);
        }
        boolean containsString = this.isAccepting(node);
        return containsString;
    }

    public static void main(String[] args) throws IOException {
        CharTrie charTrie = new CharTrie();
        charTrie.addString("Test");
        charTrie.addString("Tesd");
        charTrie.addString("Tes");
        charTrie.addString("es");
        charTrie.addString("est");
        charTrie.computeLinks();
        charTrie.finish();
        boolean containsString = charTrie.containsString("T");
        System.out.println(containsString);
        charTrie.print(System.out);
    }
}

