/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie;

import de.berlin.hu.wbi.common.map.HashByteMap;
import de.berlin.hu.wbi.common.map.PrimitiveMap;
import de.berlin.hu.wbi.common.trie.AbstractTrie;
import java.io.IOException;
import java.util.Arrays;

public class ByteTrie
extends AbstractTrie {
    private static final long serialVersionUID = 5360099023534518428L;
    private transient StringBuilder stringBuilder = new StringBuilder();
    protected byte[] values = new byte[1024];
    private byte[] buffer;

    @Override
    PrimitiveMap newMap() {
        return new HashByteMap();
    }

    public String toStringComplete() {
        this.stringBuilder.setLength(0);
        this.toStringRecursive(0);
        return this.stringBuilder.toString();
    }

    private void toStringRecursive(int node) {
        if (this.isAccepting(node)) {
            int length = this.fillBytes(node);
            String str = new String(this.initBuffer(), 0, length);
            this.stringBuilder.append(str);
            this.stringBuilder.append('\n');
        } else {
            PrimitiveMap map = this.maps[node];
            if (map != null) {
                for (int child : map.getValues()) {
                    this.toStringRecursive(child);
                }
            }
        }
    }

    @Override
    public int getValue(int node) {
        return this.values[node];
    }

    @Override
    void setValue(int node, int value) {
        this.values[node] = (byte)value;
    }

    @Override
    protected void allocate(int length) {
        super.allocate(length);
        this.values = Arrays.copyOf(this.values, length);
    }

    public void add(byte[] bytes, int start, int end) {
        end = Math.min(bytes.length, end);
        int node = 0;
        for (int pos = start; pos < end; ++pos) {
            byte value = bytes[pos];
            node = this.add(node, value);
        }
        this.end(node);
    }

    public int fillBytes(int node) {
        if (node == 0) {
            this.initBuffer();
            return 0;
        }
        int parent = this.parents[node];
        int i = this.fillBytes(parent);
        this.buffer[i] = (byte)this.getValue(node);
        return i + 1;
    }

    public byte[] getBytes(int node) {
        int i = this.fillBytes(node);
        byte[] output = Arrays.copyOf(this.buffer, i);
        return output;
    }

    public String getString(int node) {
        int i = this.fillBytes(node);
        String string = new String(this.buffer, 0, i);
        return string;
    }

    protected byte[] initBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.maxLength];
        }
        return this.buffer;
    }

    public String toString(int node) {
        int i = this.fillBytes(node);
        String string = new String(this.buffer, 0, i);
        return string;
    }

    public boolean contains(byte[] word) {
        int node = 0;
        for (byte b : word) {
            node = this.traverse(node, b);
        }
        return this.isAccepting(node);
    }

    public void add(byte[] word) {
        this.add(word, 0, word.length);
    }

    @Override
    public void addString(Object o) {
        String string = o.toString();
        byte[] bytes = string.getBytes();
        this.add(bytes);
    }

    @Override
    void printNode(int node, Appendable out) throws IOException {
    }

    @Override
    public boolean containsString(Object string) {
        byte[] bytes = string.toString().getBytes();
        return this.contains(bytes);
    }
}

