/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.trie;

import de.berlin.hu.wbi.common.map.PrimitiveMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Arrays;

public abstract class AbstractTrie
implements Serializable {
    private static final long serialVersionUID = -1606552866411058418L;
    protected int nodeCount = 1;
    protected int size = 0;
    protected int maxLength = 0;
    protected int depth = 0;
    protected PrimitiveMap[] maps = new PrimitiveMap[this.bufferSize];
    protected int[] outputs = new int[this.bufferSize];
    protected int[] failures = new int[this.bufferSize];
    protected int[] parents = new int[this.bufferSize];
    protected int bufferSize = 2;
    public static final int OFFSET = Integer.MIN_VALUE;

    public void addStrings(Object ... objects) {
        for (Object object : objects) {
            this.addString(object);
        }
    }

    public void computeLinks() {
        ArrayDeque<Integer> nodes = new ArrayDeque<Integer>();
        nodes.add(0);
        while (!nodes.isEmpty()) {
            int first = (Integer)nodes.pollFirst();
            PrimitiveMap map = this.maps[first];
            if (map != null) {
                int[] keys;
                for (int i : keys = map.getKeys()) {
                    int value = map.getValue(i);
                    nodes.addLast(value);
                }
            }
            if (first == 0) continue;
            this.computeLinks(first);
        }
    }

    private void computeLinks(int node) {
        int failure = 0;
        int parent = this.getParent(node);
        char value = (char)this.getValue(node);
        while (failure == 0 && parent > 0) {
            int parentFailureLink = this.failures[parent];
            parent = this.getParent(parent);
            PrimitiveMap map = this.maps[parentFailureLink];
            if (map == null || !map.containsKey(value)) continue;
            failure = map.getValue();
        }
        this.failures[node] = failure;
        this.outputs[node] = this.isAccepting(failure) ? failure : this.outputs[failure];
    }

    public void finish() {
        this.allocate(this.nodeCount);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getSize() {
        return this.size;
    }

    public int getParent(int node) {
        int parent = this.parents[node];
        if (parent < 0) {
            parent -= Integer.MIN_VALUE;
        }
        return parent;
    }

    public boolean isAccepting(int node) {
        boolean accepting = this.parents[node] < 0;
        return accepting;
    }

    protected void setAccepting(int node) {
        if (!this.isAccepting(node)) {
            int n = node;
            this.parents[n] = this.parents[n] + Integer.MIN_VALUE;
        }
    }

    public int traverse(int node, int value) {
        PrimitiveMap map = this.maps[node];
        int nextNode = 0;
        if (map == null && node + 1 < this.maps.length && value == this.getValue(node + 1)) {
            nextNode = node + 1;
        } else if (map != null && map.containsKey(value)) {
            nextNode = map.getValue();
        } else if (node > 0) {
            int failureLink = this.failures[node];
            nextNode = this.traverse(failureLink, value);
        }
        return nextNode;
    }

    public abstract void addString(Object var1);

    public abstract int getValue(int var1);

    abstract PrimitiveMap newMap();

    abstract void setValue(int var1, int var2);

    public int add(int node, int value) {
        PrimitiveMap map = this.maps[node];
        int next = 0;
        if (map == null) {
            this.maps[node] = map = this.newMap();
        }
        if (!map.containsKey(value)) {
            if (this.nodeCount == this.parents.length) {
                this.allocate(this.maps.length << 1);
            }
            next = this.nodeCount++;
            this.setValue(next, value);
            this.parents[next] = node;
            map.setValue(next);
        } else {
            next = map.getValue();
        }
        ++this.depth;
        return next;
    }

    protected void end(int node) {
        this.setAccepting(node);
        this.maxLength = Math.max(this.maxLength, this.depth);
        ++this.size;
        this.depth = 0;
    }

    protected void allocate(int length) {
        this.maps = Arrays.copyOf(this.maps, length);
        this.outputs = Arrays.copyOf(this.outputs, length);
        this.parents = Arrays.copyOf(this.parents, length);
        this.failures = Arrays.copyOf(this.failures, length);
    }

    public void print(Appendable out) throws IOException {
        for (int node = 0; node < this.parents.length; ++node) {
            if (!this.isAccepting(node)) continue;
            this.printNode(node, out);
            out.append('\n');
        }
    }

    public abstract boolean containsString(Object var1);

    abstract void printNode(int var1, Appendable var2) throws IOException;

    public int getFailureLink(int i) {
        return this.failures[i];
    }

    public int[] getChildren(int node) {
        PrimitiveMap map = this.maps[node];
        if (map != null) {
            return map.getValues();
        }
        return null;
    }
}

