/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.research;

import de.berlin.hu.wbi.common.research.EvalMeasures;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Evaluator<ResultType, StandardType>
implements Serializable {
    private static final long serialVersionUID = 3009808474569044273L;
    private ArrayList<ResultType> truePositives;
    private ArrayList<ResultType> falsePositives;
    private ArrayList<StandardType> falseNegatives;
    private transient Set<? extends ResultType> result;
    private transient Set<? extends StandardType> standard;
    private double precision = Double.NaN;
    private double recall = Double.NaN;
    private double fMeasure = Double.NaN;

    public Evaluator() {
    }

    public void trim() {
        if (this.truePositives != null) {
            this.truePositives.trimToSize();
        }
        if (this.falseNegatives != null) {
            this.falseNegatives.trimToSize();
        }
        if (this.falsePositives != null) {
            this.falsePositives.trimToSize();
        }
        this.result = null;
        this.standard = null;
    }

    public Evaluator(Collection<? extends ResultType> result, Collection<? extends StandardType> standard) {
        this();
        this.setResultPositives(result);
        this.setStandardPositives(standard);
    }

    public Evaluator<ResultType, StandardType> setResultPositives(Collection<? extends ResultType> result) {
        assert (this.result == null) : "Do not overwrite the result collection!";
        assert (result != null) : "Your result collection is null!";
        assert (result.size() > 0) : "Your result collection is empty!";
        this.result = new HashSet<ResultType>(result);
        return this;
    }

    public Evaluator<ResultType, StandardType> setStandardPositives(Collection<? extends StandardType> standard) {
        assert (this.standard == null) : "Do not overwrite the standard collection!";
        assert (standard != null) : "Your standard collection is null!";
        assert (standard.size() > 0) : "Your standard collection is empty!";
        this.standard = new HashSet<StandardType>(standard);
        return this;
    }

    public Evaluator<ResultType, StandardType> evaluate() {
        assert (this.result != null) : "You forgot to set the result collection!";
        assert (this.standard != null) : "You forgot to set the standard collection!";
        this.truePositives = new ArrayList(this.result.size());
        this.falsePositives = new ArrayList(this.result.size());
        this.falseNegatives = new ArrayList(this.standard.size());
        for (ResultType resultSample : this.result) {
            boolean contains = this.standard.contains(resultSample);
            if (contains) {
                this.truePositives.add(resultSample);
                continue;
            }
            this.falsePositives.add(resultSample);
        }
        for (ResultType standardSample : this.standard) {
            if (this.result.contains(standardSample)) continue;
            this.falseNegatives.add(standardSample);
        }
        return this;
    }

    private void computeFMeasure() {
        double fM;
        double p = this.getPrecision();
        double r = this.getRecall();
        this.fMeasure = fM = EvalMeasures.getFMeasure(p, r);
    }

    private void computeRecall() {
        double r;
        assert (this.truePositives != null && this.falseNegatives != null) : "You forgot to call evaluate() first!";
        int tp = this.truePositives.size();
        int fn = this.falseNegatives.size();
        this.recall = r = EvalMeasures.getRecall(tp, fn);
    }

    private void computePrecision() {
        assert (this.truePositives != null && this.falsePositives != null) : "You forgot to call evaluate() first!";
        int tp = this.truePositives.size();
        int fp = this.falsePositives.size();
        this.precision = EvalMeasures.getPrecision(tp, fp);
    }

    public double getPrecision() {
        if (Double.isNaN(this.precision)) {
            this.computePrecision();
        }
        return this.precision;
    }

    public double getRecall() {
        if (Double.isNaN(this.recall)) {
            this.computeRecall();
        }
        return this.recall;
    }

    public double getFMeasure() {
        if (Double.isNaN(this.fMeasure)) {
            this.computeFMeasure();
        }
        return this.fMeasure;
    }

    public Collection<ResultType> getTruePositives() {
        if (this.truePositives == null) {
            this.evaluate();
        }
        return Collections.unmodifiableCollection(this.truePositives);
    }

    public Collection<ResultType> getFalsePositives() {
        if (this.falsePositives == null) {
            this.evaluate();
        }
        return Collections.unmodifiableCollection(this.falsePositives);
    }

    public Collection<StandardType> getFalseNegatives() {
        if (this.falseNegatives == null) {
            this.evaluate();
        }
        return Collections.unmodifiableCollection(this.falseNegatives);
    }

    public static <R, S> Evaluator<R, S> create(Collection<R> result, Collection<S> standard) {
        return new Evaluator<R, S>(result, standard);
    }

    public static <R, S> Evaluator<R, S> create() {
        return new Evaluator();
    }

    public static <T> double getPrecision(Collection<T> result, Collection<T> standard) {
        return Evaluator.create(result, standard).getPrecision();
    }

    public static <T extends Comparable<? super T>> double getRecall(Collection<T> result, Collection<T> standard) {
        return Evaluator.create(result, standard).getRecall();
    }

    public static <T> double getFMeasur(Collection<T> result, Collection<T> standard) {
        return Evaluator.create(result, standard).getFMeasure();
    }

    public static <T> Collection<T> getTruePositives(Collection<T> result, Collection<T> standard) {
        return Evaluator.create(result, standard).getTruePositives();
    }

    public static <T> Collection<T> getFalsePositives(Collection<T> result, Collection<T> standard) {
        return Evaluator.create(result, standard).getFalsePositives();
    }

    public static <T> Collection<T> getFalseNagatives(Collection<T> result, Collection<T> standard) {
        return Evaluator.create(result, standard).getFalsePositives();
    }

    public int getNumberOfTP() {
        return this.truePositives.size();
    }

    public int getNumberOfFP() {
        return this.falsePositives.size();
    }

    public int getNumberOfFN() {
        return this.falseNegatives.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Evaluator [truePositives=");
        builder.append(this.truePositives.size());
        builder.append(", falsePositives=");
        builder.append(this.falsePositives.size());
        builder.append(", falseNegatives=");
        builder.append(this.falseNegatives.size());
        builder.append("]");
        return builder.toString();
    }
}

