/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.reflection;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Introspection {
    public static Collection<String> exclude = new HashSet<String>(Arrays.asList("Integer", "Boolean", "String", "Byte", "Long", "Short", "Double", "Float"));
    public static Collection<String> primitiveArrays = new HashSet<String>(Arrays.asList("byte[]", "int[]", "double[]", "char[]", "long[]", "short[]", "boolean[]"));

    public static void printObject(Object object, int depth, int maxDepth, Matcher include) {
        block7: {
            String simpleName;
            String className;
            Class<?> objectClass;
            block10: {
                boolean isIterable;
                block9: {
                    Object[] objectArray;
                    boolean isObjectArray;
                    block8: {
                        if (depth > maxDepth) break block7;
                        Introspection.printWhiteSpace(depth);
                        objectClass = object.getClass();
                        className = objectClass.getCanonicalName();
                        simpleName = object.getClass().getSimpleName();
                        String stringValue = Introspection.getStringRepresentation(object, className);
                        boolean isPrimitveArray = primitiveArrays.contains(className);
                        isObjectArray = objectClass.isArray() && !isPrimitveArray;
                        isIterable = Iterable.class.isAssignableFrom(objectClass);
                        if (!isPrimitveArray) break block8;
                        stringValue = Introspection.getStringRepresentation(object, className);
                        System.out.println(simpleName + "=" + stringValue);
                        break block7;
                    }
                    if (!isObjectArray) break block9;
                    for (Object element : objectArray = (Object[])object) {
                        Introspection.printObject(element, depth + 1, maxDepth, include);
                    }
                    break block7;
                }
                if (!isIterable) break block10;
                Collection iterable = (Collection)object;
                for (Object element : iterable) {
                    Introspection.printObject(element, depth + 1, maxDepth, include);
                }
                break block7;
            }
            if (exclude.contains(simpleName) || include.reset(className).matches() || depth >= maxDepth) break block7;
            for (Method m : objectClass.getDeclaredMethods()) {
                boolean hasNoParameters = m.getParameterTypes().length == 0;
                String methodName = m.getName();
                if (!hasNoParameters || "toString".equals(methodName)) continue;
                Introspection.printWhiteSpace(depth);
                System.out.print(m.getName() + "()=");
                try {
                    Object returnValue = m.invoke(object, new Object[0]);
                    if (returnValue != null) {
                        className = returnValue.getClass().getCanonicalName();
                        if (!include.reset(className).matches()) {
                            System.out.println(returnValue);
                            continue;
                        }
                        System.out.println();
                        Introspection.printObject(returnValue, depth + 1, maxDepth, include);
                        continue;
                    }
                    System.out.println(returnValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private static void printWhiteSpace(int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.print('\t');
        }
    }

    private static String getStringRepresentation(Object object, String className) {
        String stringValue = null;
        if ("byte[]".equals(className)) {
            stringValue = Arrays.toString((byte[])object);
        } else if ("int[]".equals(className)) {
            stringValue = Arrays.toString((int[])object);
        } else if ("double[]".equals(className)) {
            stringValue = Arrays.toString((double[])object);
        } else if ("char[]".equals(className)) {
            stringValue = Arrays.toString((char[])object);
        } else if ("long[]".equals(className)) {
            stringValue = Arrays.toString((long[])object);
        } else if ("short[]".equals(className)) {
            stringValue = Arrays.toString((short[])object);
        } else {
            stringValue = object.toString();
            int end = Math.min(100, stringValue.length());
            stringValue = stringValue.substring(0, end);
        }
        return stringValue;
    }

    public static void printObject(Object o, int maxDepth, String include) {
        Matcher matcher = Pattern.compile(include).matcher("");
        Introspection.printObject(o, 0, maxDepth, matcher);
    }

    public static void main(String[] args) {
        Introspection.printObject("hallo", 1, ".*");
    }
}

