/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.prototype;

import de.berlin.hu.wbi.common.misc.Timer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallizedEditDistance
implements Runnable {
    double[][] m;
    BlockingQueue<int[]> open;
    Queue<int[]> buf;
    private AtomicInteger count;
    private CharSequence a;
    private CharSequence b;
    private int maxCount;
    private int me;

    public ParallizedEditDistance(CharSequence a, CharSequence b, double[][] m, BlockingQueue<int[]> open, AtomicInteger count, int maxCount, Queue<int[]> buf) {
        this.m = m;
        this.open = open;
        this.count = count;
        this.a = a;
        this.b = b;
        this.maxCount = maxCount;
        this.buf = buf;
    }

    @Override
    public void run() {
        System.out.println(Thread.currentThread());
        int[] take = null;
        while (this.count.get() < this.maxCount) {
            try {
                take = this.open.poll(1L, TimeUnit.SECONDS);
                if (take != null) {
                    double entry;
                    int x = take[0];
                    int y = take[1];
                    this.buf.add(take);
                    this.m[x][y] = entry = this.getEntry(x, y);
                    if (x < this.a.length() && this.m[x + 1][y - 1] > 0.0) {
                        take = !this.buf.isEmpty() ? this.buf.poll() : new int[]{x + 1, y};
                        this.open.put(take);
                    }
                    if (y < this.b.length() && this.m[x - 1][y + 1] > 0.0) {
                        take = !this.buf.isEmpty() ? this.buf.poll() : new int[]{x, y + 1};
                        this.open.put(take);
                    }
                    this.count.incrementAndGet();
                    ++this.me;
                    continue;
                }
                System.out.println(this.open);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println(Thread.currentThread() + ": " + this.me);
    }

    public double getEntry(int i, int j) {
        double value = 0.0;
        value = this.a.charAt(i - 1) == this.b.charAt(j - 1) ? this.m[i - 1][j - 1] : this.m[i - 1][j - 1] + 1.0;
        value = Math.min(value, this.m[i - 1][j] + 1.0);
        value = Math.min(value, this.m[i][j - 1] + 1.0);
        return value;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.m.length; ++i) {
            b.append(Arrays.toString(this.m[i])).append('\n');
        }
        return b.toString();
    }

    public static void main(String[] args) throws InterruptedException {
        String a = "SebastiandsfgsgsdhsdhsdhshsdghzsdhsdhsdhsdhsdhsdhfsdhsdhaserhzaerhSebastiandsfgsgsdhsdhsdhshsdghzsdhsdhsdhsdhsdhsdhfsdhsdhaserhzaerhSebastiandsfgsgsdhsdhsdhshsdghzsdhsdhsdhsdhsdhsdhfsdhsdhaserhzaerhSebastiandsfgsgsdhsdhsdhshsdghzsdhsdhsdhsdhsdhsdhfsdhsdhaserhzaerhSebastiandsfgsgsdhsdhsdhshsdghzsdhsdhsdhsdhsdhsdhfsdhsdhaserhzaerh";
        String b = "Seabstiansdhsdhsdghsdhsdghshsdghsdhsdhgsdhdfjhsthasertdfghaezsesdhsdhsdghsdhsdghshsdghsdhsdhgsdhdfsdhsdhsdghsdhsdghshsdghsdhsdhgsdhdfsdhsdhsdghsdhsdghshsdghsdhsdhgsdhdfsdhsdhsdghsdhsdghshsdghsdhsdhgsdhdfsdhsdhsdghsdhsdghshsdghsdhsdhgsdhdfsdhsdhsdghsdhsdghshsdghsdhsdhgsdhdfsdhsdhsdghsdhsdghshsdghsdhsdhgsdhdf";
        double[][] m = new double[a.length() + 1][b.length() + 1];
        ParallizedEditDistance.init(m);
        ArrayBlockingQueue<int[]> open = new ArrayBlockingQueue<int[]>(1000000);
        open.add(new int[]{1, 1});
        AtomicInteger count = new AtomicInteger(0);
        int maxCount = a.length() * b.length();
        ArrayDeque<int[]> buf = new ArrayDeque<int[]>();
        ParallizedEditDistance d1 = new ParallizedEditDistance(a, b, m, open, count, maxCount, buf);
        ParallizedEditDistance d2 = new ParallizedEditDistance(a, b, m, open, count, maxCount, buf);
        ParallizedEditDistance d3 = new ParallizedEditDistance(a, b, m, open, count, maxCount, buf);
        Timer t = Timer.startTimerMilli();
        ExecutorService pool = Executors.newCachedThreadPool();
        pool.submit(d1);
        pool.submit(d2);
        pool.submit(d3);
        pool.shutdown();
        pool.awaitTermination(100L, TimeUnit.DAYS);
        t.print();
    }

    public static void init(double[][] m) {
        int i;
        for (i = 0; i < m.length; ++i) {
            m[i][0] = i + 1;
        }
        for (i = 0; i < m[0].length; ++i) {
            m[0][i] = i + 1;
        }
    }
}

