/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class WgetDownloader {
    private static final String COMMAND_PATTERN = "wget -P %s %s";
    Process process;
    String command;
    String url;
    String dir;
    double progress;
    boolean interupted = false;
    long fileLength;
    File target;
    Thread processThread;
    int errorCode;

    public WgetDownloader(String url, String dir) {
        this.dir = dir;
        this.url = url;
        this.command = String.format(COMMAND_PATTERN, dir, url);
    }

    public void startDownloading() throws IOException {
        this.process = Runtime.getRuntime().exec(this.command);
        this.processThread = new Thread(){

            @Override
            public void run() {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(WgetDownloader.this.process.getErrorStream()));
                    String line = reader.readLine();
                    while (line != null && !WgetDownloader.this.interupted) {
                        int indexOfSize = line.indexOf("SIZE");
                        int indexOfPercent = line.indexOf(37);
                        int indexOfDir = line.indexOf(WgetDownloader.this.dir);
                        if (indexOfSize > -1) {
                            String length = line.substring(line.lastIndexOf(32) + 1).trim();
                            WgetDownloader.this.fileLength = Long.parseLong(length);
                        }
                        if (indexOfDir > -1 && WgetDownloader.this.target == null) {
                            WgetDownloader.this.target = new File(line.substring(indexOfDir, line.length() - 1));
                        }
                        if (indexOfPercent > -1) {
                            String value = line.substring(indexOfPercent - 3, indexOfPercent).trim();
                            WgetDownloader.this.progress = (double)Integer.parseInt(value) / 100.0;
                        }
                        line = reader.readLine();
                    }
                    reader.close();
                    WgetDownloader.this.errorCode = WgetDownloader.this.process.waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.processThread.start();
    }

    public void joinProcessThread() throws InterruptedException {
        this.processThread.join();
    }

    public void cancel() {
        this.interupted = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public double getProgress() {
        return this.progress;
    }

    public File getTarget() {
        if (this.target.exists()) {
            return this.target;
        }
        return null;
    }

    public boolean isRunning(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.processThread != null) {
            return this.processThread.isAlive();
        }
        return false;
    }

    public static File download(String url, String dir) throws IOException {
        String command = String.format(COMMAND_PATTERN, dir, url);
        System.out.println(command);
        Process downloader = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(downloader.getErrorStream()));
        String line = reader.readLine();
        while (line != null) {
            System.out.println(line);
            line = reader.readLine();
        }
        return null;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        WgetDownloader test = new WgetDownloader("ftp://ftp.genome.jp/pub/kegg/release/current/biopax.tar.gz", "/tmp/arzt/");
        test.startDownloading();
        while (test.isRunning(10)) {
            System.out.println(test.getProgress());
        }
        File target = test.getTarget();
        System.out.println(target.getAbsolutePath());
    }
}

