/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.mysql;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class MySqlKit {
    private static final String DEFAULT_FILE = "./db.properties";
    private File source;
    private Properties properties;

    private MySqlKit(File source) {
        this.source = source;
        this.properties = new Properties();
        for (DBProperties property : DBProperties.values()) {
            this.properties.setProperty(property.toString(), property.defaultValue);
        }
    }

    public static MySqlKit initFromWorkingDirectory(String file) {
        File workingDir = new File(".");
        if (file == null) {
            file = DEFAULT_FILE;
        }
        File conFile = new File(workingDir, file);
        return new MySqlKit(conFile);
    }

    public static MySqlKit initFromDotFolder(String pathSuffix) {
        File home = new File(System.getProperty("user.home"));
        if (pathSuffix == null) {
            pathSuffix = DEFAULT_FILE;
        }
        File configFile = new File(home, pathSuffix);
        return new MySqlKit(configFile);
    }

    public static MySqlKit initFromAbsolutePath(String absoluteFilePath) {
        File configFile = absoluteFilePath == null ? new File(DEFAULT_FILE) : new File(absoluteFilePath);
        return new MySqlKit(configFile);
    }

    public static MysqlDataSource getMySqlDataSource(Properties properties) {
        MysqlDataSource dataSource = new MysqlDataSource();
        String user = properties.getProperty(DBProperties.user.toString(), DBProperties.user.getDefaultValue());
        String password = properties.getProperty(DBProperties.password.toString(), DBProperties.password.getDefaultValue());
        String database = properties.getProperty(DBProperties.database.toString(), DBProperties.database.getDefaultValue());
        String server = properties.getProperty(DBProperties.server.toString(), DBProperties.server.getDefaultValue());
        String port = properties.getProperty(DBProperties.port.toString(), DBProperties.port.defaultValue);
        if (!user.isEmpty()) {
            dataSource.setUser(user);
        }
        if (!password.isEmpty()) {
            dataSource.setPassword(password);
        }
        if (!database.isEmpty()) {
            dataSource.setDatabaseName(database);
        }
        if (!port.isEmpty()) {
            dataSource.setPort(Integer.parseInt(port));
        }
        if (!server.isEmpty()) {
            dataSource.setServerName(server);
        }
        return dataSource;
    }

    public static MysqlDataSource getMysqlDataSource(String propertiesFile) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        return MySqlKit.getMySqlDataSource(properties);
    }

    public MysqlDataSource getMySQLDataSource() throws IOException {
        if (!this.source.exists()) {
            File path = this.source.getParentFile();
            path.mkdirs();
            this.source.createNewFile();
            this.properties.store(new FileOutputStream(this.source), "Set the database connection parameter here:");
            System.err.println("Created file '" + this.source.getAbsolutePath() + "'. Please edit to connect to database...");
            try {
                MySqlKit.openTextFileEditor("gedit", this.source);
            }
            catch (Exception e) {
                MySqlKit.openTextFileEditor("emacs", this.source);
            }
        }
        this.properties.load(new FileInputStream(this.source));
        return MySqlKit.getMySqlDataSource(this.properties);
    }

    public Connection getConnection() throws SQLException, IOException {
        MysqlDataSource mySQLDataSource = this.getMySQLDataSource();
        return mySQLDataSource.getConnection();
    }

    public static int openTextFileEditor(String editorCommand, File textFile) throws IOException {
        String path = textFile.getAbsolutePath();
        Process exec = new ProcessBuilder(editorCommand, path).start();
        try {
            return exec.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setDefaultValue(DBProperties key, String value) {
        this.properties.setProperty(key.toString(), value);
    }

    public static enum DBProperties {
        user("root"),
        password(""),
        database(""),
        port(""),
        server("localhost");

        private String defaultValue;

        private DBProperties(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

