/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;

public class WbiStringBuilder {
    protected StringBuilder builder;

    public WbiStringBuilder(StringBuilder b) {
        this.builder = b;
    }

    public WbiStringBuilder() {
        this.builder = new StringBuilder();
    }

    public void add(Object ... objects) {
        for (Object object : objects) {
            String string = this.toString(object);
            this.builder.append(string);
        }
    }

    public void newLine() {
        this.add(Character.valueOf('\n'));
    }

    public void sep(Object separator, Object ... objects) {
        int last = objects.length - 1;
        for (int i = 0; i < last; ++i) {
            this.add(objects[i]);
            this.add(separator);
        }
        if (objects.length > 0) {
            this.add(objects[last]);
        }
    }

    public String toString(Object o) {
        return o.toString();
    }

    public StringBuilder getStringBuilder() {
        return this.builder;
    }

    public String toString() {
        return this.builder.toString();
    }

    public void toClipBoard() {
        String data = this.toString();
        System.out.println("Transeffing following data to clipboard:");
        System.out.println(data);
        StringSelection contents = new StringSelection(data);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, null);
        System.out.println("Press <Enter> after inserting to exit.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CharSequence toCharSequence() {
        return this.builder;
    }

    public void comma(Object ... elements) {
        this.sep(", ", elements);
        this.newLine();
    }

    public void tab(Object ... elements) {
        this.sep(Character.valueOf('\t'), elements);
        this.newLine();
    }

    public void putln(Object ... elements) {
        this.add(elements);
        this.newLine();
    }
}

