/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import java.io.PrintStream;

public class Timer {
    private long start;
    private Precision precision;
    public static final String timeFormat = "%02d:%02d:%02d";

    private Timer(Precision precision) {
        this.precision = precision;
        this.start();
    }

    public static Timer startTimerMilli() {
        return new Timer(Precision.MS);
    }

    public static Timer startTimerNano() {
        return new Timer(Precision.NS);
    }

    public long start() {
        long stop = this.stop();
        this.start = this.currentTime();
        return stop;
    }

    private long currentTime() {
        return this.precision == Precision.MS ? System.currentTimeMillis() : System.nanoTime();
    }

    public long stop() {
        return this.currentTime() - this.start;
    }

    public long print(String message, PrintStream s) {
        long time = this.stop();
        s.println(message);
        s.print("\ttime: ");
        s.print(time);
        switch (this.precision) {
            case MS: {
                s.println(" ms");
                break;
            }
            case NS: {
                s.println(" ns");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return time;
    }

    public static String timeToString(long millis) {
        int hours = (int)(millis / 3600000L) % 24;
        int minutes = (int)(millis / 60000L) % 60;
        int seconds = (int)(millis / 1000L) % 60;
        return String.format(timeFormat, hours, minutes, seconds);
    }

    public void print(String message) {
        this.print(message, System.out);
    }

    public void print() {
        this.print("", System.out);
    }

    public long getRemainingTime(double progress) {
        if (progress > 0.0 && progress <= 1.0) {
            long runningTime = this.stop();
            double remainingTime = (double)runningTime / progress - (double)runningTime;
            return (long)remainingTime;
        }
        return Long.MAX_VALUE;
    }

    public void printRemainingTime(double d) {
        long remainingTime = this.getRemainingTime(d);
        String time = Timer.timeToString(remainingTime);
        System.out.println(time);
    }

    public String getRemainingTimeString(double d) {
        return Timer.timeToString(this.getRemainingTime(d));
    }

    private static enum Precision {
        MS,
        NS;

    }
}

