/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import de.berlin.hu.wbi.common.io.IO;
import de.berlin.hu.wbi.common.misc.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SwtToolkit {
    public static final String CLASSNAME_SWT = "org.eclipse.swt.SWT";
    public static final String JAR_NAME = "swt.jar";

    public boolean isSwtLoaded() {
        try {
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            loader.loadClass(CLASSNAME_SWT);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public InputStream getJarInputStream(InputStream input) throws IOException {
        ZipInputStream in = new ZipInputStream(input);
        ZipEntry nextEntry = in.getNextEntry();
        while (nextEntry != null) {
            if (nextEntry.getName().endsWith(JAR_NAME)) {
                return in;
            }
            nextEntry = in.getNextEntry();
        }
        return null;
    }

    public void loadSwtJar(File searchDir, File swtJarFile) throws IOException {
        if (!swtJarFile.exists() || swtJarFile.length() <= 0L) {
            if (searchDir == null) {
                searchDir = new File(".").getCanonicalFile();
            }
            swtJarFile.getParentFile().mkdirs();
            Matcher zipMatcher = Pattern.compile(".*/swt[^/]*.zip").matcher("");
            List<File> files = Files.listFiles(searchDir);
            InputStream inputStream = null;
            for (File file : files) {
                String path = file.getCanonicalPath();
                zipMatcher.reset(path);
                if (path.endsWith(JAR_NAME)) {
                    inputStream = new FileInputStream(file);
                    break;
                }
                if (!zipMatcher.matches()) continue;
                inputStream = this.getJarInputStream(new FileInputStream(file));
                break;
            }
            if (inputStream != null) {
                swtJarFile.getParentFile().mkdirs();
                FileOutputStream outputStream = new FileOutputStream(swtJarFile);
                IO.copy(inputStream, outputStream);
            } else {
                throw new RuntimeException("Could not find SWT libraries! Please place appropriate *.zip file or swt.jar to '" + searchDir + "'.");
            }
        }
    }
}

