/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ListSet<E>
extends HashSet<E> {
    private static final long serialVersionUID = 1L;
    private ArrayList<E> list = new ArrayList();

    public ListSet() {
    }

    public ListSet(Collection<? extends E> c) {
        super(c.size());
        this.addAll(c);
    }

    public ListSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.list.ensureCapacity(initialCapacity);
    }

    public ListSet(int initialCapacity) {
        super(initialCapacity);
        this.list.ensureCapacity(initialCapacity);
    }

    @Override
    public boolean add(E e) {
        boolean newElement = super.add(e);
        if (newElement) {
            this.list.add(e);
        }
        return newElement;
    }

    @Override
    public void clear() {
        super.clear();
        this.list.clear();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean contains = super.remove(o);
        if (contains) {
            this.list.remove(o);
        }
        return contains;
    }

    public static void main(String[] args) {
        List<Object> values = Arrays.asList(10, 2, 3, 4, 3, 2, 1);
        HashSet test = new ListSet<Object>(values);
        System.out.println(test);
        test = new HashSet<Object>(test);
        System.out.println(test);
    }
}

