/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class LineBasedParser {
    protected int currentLineNumber;
    protected long maxLineNumber = Long.MAX_VALUE;
    private boolean isInterrupted = false;

    public int getCurrentLineNumber() {
        return this.currentLineNumber;
    }

    public abstract void performLine(String var1);

    public void setMaxLineNumber(long maxLineNumber) {
        this.maxLineNumber = maxLineNumber;
    }

    public void parse(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        this.parse(reader);
    }

    public void interruptParsing() {
        this.isInterrupted = true;
    }

    public void parse(BufferedReader reader) throws IOException {
        this.currentLineNumber = 0;
        String line = reader.readLine();
        while (line != null && !this.isInterrupted && (long)this.currentLineNumber < this.maxLineNumber) {
            ++this.currentLineNumber;
            this.performLine(line);
            if (this.currentLineNumber % 1000000 == 0) {
                System.out.format("Zeile: %d\n", this.currentLineNumber);
            }
            line = reader.readLine();
        }
    }
}

