/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import de.berlin.hu.wbi.common.misc.Tool;
import de.berlin.hu.wbi.common.misc.WbiStringBuilder;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;

public abstract class LatexTableBuilder
extends WbiStringBuilder {
    protected String separator = " & ";
    protected String caption = "";
    protected String columns = "";
    protected String title = "";
    protected String width = "{\\textwidth}";
    protected String label = "";
    protected DecimalFormat format = new DecimalFormat("###,###,###.##");
    public String template = "\\begin{table}[%s]\n\\centering\n\\begin{%s}%s{%s}\n%s\\end{%s}\n\\caption[%s]{%s}\n\\label{table_%s}\n\\end{table}";

    public WbiStringBuilder cell(int i) {
        for (int j = 0; j < i; ++j) {
            this.add(this.separator);
        }
        return this;
    }

    public void setFormat(DecimalFormat format) {
        this.format = format;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public abstract String getLatexFolder();

    protected String getPlacement() {
        return "htbp";
    }

    protected String getTableSubFolder() {
        return "table";
    }

    protected String getTabularEnvironmentName() {
        return "tabularx";
    }

    protected String getWidth() {
        return this.width;
    }

    public void setColumns(String columns) {
        this.columns = columns;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void offsetRow(int offset, Object ... elements) {
        this.cell(offset);
        this.row(elements);
    }

    public void row(Object ... elements) {
        this.sep(this.separator, elements);
        this.newRow();
    }

    @Override
    public String toString(Object o) {
        if (o instanceof Number && this.format != null) {
            return this.format.format(o);
        }
        return super.toString(o);
    }

    public void newCell() {
        super.add(this.separator);
    }

    public void newRow() {
        this.add("\\\\");
        this.newLine();
    }

    public void midrule() {
        this.add("\\midrule");
        this.newLine();
    }

    public void bottomrule() {
        this.add("\\bottomrule");
        this.newLine();
    }

    public void toprule() {
        this.add("\\toprule");
        this.newLine();
    }

    public void cmidrule(int from, int to) {
        this.add("\\cmidrule{", from, Character.valueOf('-'), to, Character.valueOf('}'));
        this.newLine();
    }

    public void store(Appendable stream) throws IOException {
        stream.append(this.getTable());
    }

    public void store() throws IOException {
        this.store(Tool.getMethodName(3));
    }

    public void store(String name) throws IOException {
        File tableDirectory = new File(this.getLatexFolder(), this.getTableSubFolder());
        if (tableDirectory.exists() && !tableDirectory.isDirectory()) {
            throw new IOException("'" + tableDirectory.getAbsolutePath() + "' is not a directory.");
        }
        if (!tableDirectory.exists() && !tableDirectory.mkdirs()) {
            throw new IOException("Could not create directory '" + tableDirectory.getAbsolutePath() + "'.");
        }
        String tableName = name + ".tex";
        File tableFile = new File(tableDirectory, tableName);
        String path = Tool.getSubDirectory(2, tableFile);
        String inputString = "\\input{" + path + "}";
        PrintStream stream = new PrintStream(tableFile);
        System.out.println(tableFile);
        System.out.println(inputString);
        this.store(stream);
    }

    public String getTable() {
        return String.format(this.template, this.getPlacement(), this.getTabularEnvironmentName(), this.getWidth(), this.columns, this, this.getTabularEnvironmentName(), this.title, this.caption, this.label);
    }

    public static void main(String[] args) throws IOException {
        LatexTableBuilder b = new LatexTableBuilder(){

            @Override
            public String getLatexFolder() {
                try {
                    return new File(".").getCanonicalPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        b.toprule();
        b.row(1, 2, 3, 4, 5);
        b.midrule();
        b.row("Hallo", "dies", "ist", "ein", "Test");
        b.bottomrule();
        System.out.println(b.getTable());
        b.store();
    }
}

