/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import de.berlin.hu.wbi.common.filter.Filter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Files {
    public static List<File> listFiles(File file) {
        ArrayList<File> files = new ArrayList<File>();
        Files.listFilesRecursively(files, file);
        return files;
    }

    public static List<File> listFiles(File file, Filter<File> filter) throws Exception {
        ArrayList<File> files = new ArrayList<File>();
        Files.listFilesRecursively(files, file, filter);
        return files;
    }

    private static void listFilesRecursively(List<File> files, File file, Filter<File> filter) throws Exception {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    Files.listFilesRecursively(files, child, filter);
                }
            }
        } else if (file.isFile() && filter.accept(file)) {
            files.add(file);
        }
    }

    private static void listFilesRecursively(List<File> files, File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    Files.listFilesRecursively(files, child);
                }
            }
        } else if (file.isFile()) {
            files.add(file);
        }
    }

    public static void main(String[] args) {
        File f = new File("/vol/fob-vol5/mi06/arzt");
        List<File> list = Files.listFiles(f);
        System.out.println(list.size());
        for (File file : list) {
            System.out.println(file.getName());
        }
    }
}

