/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.misc;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;

public class Appender<A extends Appendable> {
    private A appendable;

    public Appender(A appendable) {
        this.appendable = appendable;
    }

    public void setAppendable(A appendable) {
        this.appendable = appendable;
    }

    public A getAppendable() {
        return this.appendable;
    }

    public void append(Object ... objects) {
        for (Object object : objects) {
            try {
                this.appendable.append(object.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void appendLine(Object ... objects) {
        this.append(objects);
        try {
            this.appendable.append('\n');
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void repeat(Appendable a, int repetition, Object ... objects) {
        for (int i = 0; i < repetition; ++i) {
            this.append(objects);
        }
    }

    public String toString() {
        return this.appendable.toString();
    }

    public static void main(String[] args) {
        Appender<PrintStream> out = new Appender<PrintStream>(System.out);
        out.append(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        out.appendLine(new Object[0]);
        out.append(0, 1, 2, 3.9, 4, 5, 6, 7, 8, 9, new Date());
        out.append(out);
    }
}

