/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.map;

import de.berlin.hu.wbi.common.map.AbstractByteIntMap;
import de.berlin.hu.wbi.common.map.HashByteIntMap;
import de.berlin.hu.wbi.common.map.PrimitveMap;
import java.util.Arrays;

public class MyByteIntMap
implements PrimitveMap {
    private static final long serialVersionUID = -4919654141469909707L;
    byte[] keys;
    int[] values;

    @Override
    public void put(int b, int i) {
        int j = Arrays.binarySearch(this.keys, (byte)b);
        this.values[j] = i;
    }

    @Override
    public int get(int b) {
        int i = Arrays.binarySearch(this.keys, (byte)b);
        if (i < 0) {
            return -1;
        }
        return this.values[i];
    }

    @Override
    public int getSize() {
        return this.keys.length;
    }

    @Override
    public void addAll(PrimitveMap map) {
        int size = map.getSize();
        this.keys = new byte[size];
        this.values = new int[size];
        int i = 0;
        for (byte key : AbstractByteIntMap.BYTES) {
            int value = map.get(key);
            if (value < 0) continue;
            this.keys[i] = key;
            this.values[i] = value;
            ++i;
        }
    }

    public static void main(String[] args) {
        HashByteIntMap map = new HashByteIntMap();
        map.put(1, 17);
        map.put(-120, 6);
        map.put(-24, 3563);
        map.put(96, -254);
        MyByteIntMap m = new MyByteIntMap();
        m.addAll(map);
        System.out.println(m.get(1));
        System.out.println(m.get(2));
        System.out.println(m.get(-24));
    }
}

