/*
 * Decompiled with CFR 0.152.
 */
package de.berlin.hu.wbi.common.map;

import de.berlin.hu.wbi.common.map.PrimitiveMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HashByteMap
extends HashMap<Byte, Integer>
implements PrimitiveMap {
    private static final long serialVersionUID = -4135132546258766734L;
    private byte key;

    public HashByteMap() {
    }

    public HashByteMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public HashByteMap(int initialCapacity) {
        super(initialCapacity);
    }

    public HashByteMap(Map<? extends Byte, ? extends Integer> m) {
        super(m);
    }

    @Override
    public int getSize() {
        return super.size();
    }

    @Override
    public void addAll(PrimitiveMap map) {
        for (int key : map.getKeys()) {
            map.containsKey(key);
            int value = map.getValue();
            super.put((byte)key, value);
        }
    }

    @Override
    public void setValue(int value) {
        super.put(this.key, value);
    }

    @Override
    public boolean containsKey(int key) {
        this.key = (byte)key;
        return super.containsKey(key);
    }

    @Override
    public int getValue() {
        return (Integer)super.get(this.key);
    }

    @Override
    public int[] getKeys() {
        Set keySet = super.keySet();
        int[] keys = new int[keySet.size()];
        int i = 0;
        for (Byte key : keySet) {
            keys[i] = key.byteValue();
            ++i;
        }
        return keys;
    }

    @Override
    public int getValue(int key) {
        return (Integer)super.get(key);
    }

    @Override
    public int[] getValues() {
        Collection valuesCollection = super.values();
        int[] values = new int[valuesCollection.size()];
        int i = 0;
        for (Integer integer : valuesCollection) {
            values[i] = integer;
            ++i;
        }
        return values;
    }
}

